/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.deepseek.api;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.deepseek.api.DeepSeekApi;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DeepSeekStreamFunctionCallingHelper {
    public DeepSeekApi.ChatCompletionChunk merge(DeepSeekApi.ChatCompletionChunk previous, DeepSeekApi.ChatCompletionChunk current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        Long created = current.created() != null ? current.created() : previous.created();
        String model = current.model() != null ? current.model() : previous.model();
        String serviceTier = current.serviceTier() != null ? current.serviceTier() : previous.serviceTier();
        String systemFingerprint = current.systemFingerprint() != null ? current.systemFingerprint() : previous.systemFingerprint();
        String object = current.object() != null ? current.object() : previous.object();
        DeepSeekApi.Usage usage = current.usage() != null ? current.usage() : previous.usage();
        DeepSeekApi.ChatCompletionChunk.ChunkChoice previousChoice0 = CollectionUtils.isEmpty(previous.choices()) ? null : previous.choices().get(0);
        DeepSeekApi.ChatCompletionChunk.ChunkChoice currentChoice0 = CollectionUtils.isEmpty(current.choices()) ? null : current.choices().get(0);
        DeepSeekApi.ChatCompletionChunk.ChunkChoice choice = this.merge(previousChoice0, currentChoice0);
        List<DeepSeekApi.ChatCompletionChunk.ChunkChoice> chunkChoices = choice == null ? List.of() : List.of(choice);
        return new DeepSeekApi.ChatCompletionChunk(id, chunkChoices, created, model, serviceTier, systemFingerprint, object, usage);
    }

    private DeepSeekApi.ChatCompletionChunk.ChunkChoice merge(DeepSeekApi.ChatCompletionChunk.ChunkChoice previous, DeepSeekApi.ChatCompletionChunk.ChunkChoice current) {
        if (previous == null) {
            return current;
        }
        DeepSeekApi.ChatCompletionFinishReason finishReason = current.finishReason() != null ? current.finishReason() : previous.finishReason();
        Integer index = current.index() != null ? current.index() : previous.index();
        DeepSeekApi.ChatCompletionMessage message = this.merge(previous.delta(), current.delta());
        DeepSeekApi.LogProbs logprobs = current.logprobs() != null ? current.logprobs() : previous.logprobs();
        return new DeepSeekApi.ChatCompletionChunk.ChunkChoice(finishReason, index, message, logprobs);
    }

    private DeepSeekApi.ChatCompletionMessage merge(DeepSeekApi.ChatCompletionMessage previous, DeepSeekApi.ChatCompletionMessage current) {
        String content = current.content() != null ? current.content() : (previous.content() != null ? previous.content() : "");
        DeepSeekApi.ChatCompletionMessage.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : DeepSeekApi.ChatCompletionMessage.Role.ASSISTANT;
        String name = current.name() != null ? current.name() : previous.name();
        String toolCallId = current.toolCallId() != null ? current.toolCallId() : previous.toolCallId();
        ArrayList<DeepSeekApi.ChatCompletionMessage.ToolCall> toolCalls = new ArrayList<DeepSeekApi.ChatCompletionMessage.ToolCall>();
        DeepSeekApi.ChatCompletionMessage.ToolCall lastPreviousTooCall = null;
        if (previous.toolCalls() != null) {
            lastPreviousTooCall = previous.toolCalls().get(previous.toolCalls().size() - 1);
            if (previous.toolCalls().size() > 1) {
                toolCalls.addAll(previous.toolCalls().subList(0, previous.toolCalls().size() - 1));
            }
        }
        if (current.toolCalls() != null) {
            if (current.toolCalls().size() > 1) {
                throw new IllegalStateException("Currently only one tool call is supported per message!");
            }
            DeepSeekApi.ChatCompletionMessage.ToolCall currentToolCall = current.toolCalls().iterator().next();
            if (StringUtils.hasText((String)currentToolCall.id())) {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(currentToolCall);
            } else {
                toolCalls.add(this.merge(lastPreviousTooCall, currentToolCall));
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return new DeepSeekApi.ChatCompletionMessage(content, role, name, toolCallId, toolCalls);
    }

    private DeepSeekApi.ChatCompletionMessage.ToolCall merge(DeepSeekApi.ChatCompletionMessage.ToolCall previous, DeepSeekApi.ChatCompletionMessage.ToolCall current) {
        if (previous == null) {
            return current;
        }
        String id = StringUtils.hasText((String)current.id()) ? current.id() : previous.id();
        String type = current.type() != null ? current.type() : previous.type();
        DeepSeekApi.ChatCompletionMessage.ChatCompletionFunction function = this.merge(previous.function(), current.function());
        return new DeepSeekApi.ChatCompletionMessage.ToolCall(id, type, function);
    }

    private DeepSeekApi.ChatCompletionMessage.ChatCompletionFunction merge(DeepSeekApi.ChatCompletionMessage.ChatCompletionFunction previous, DeepSeekApi.ChatCompletionMessage.ChatCompletionFunction current) {
        if (previous == null) {
            return current;
        }
        String name = StringUtils.hasText((String)current.name()) ? current.name() : previous.name();
        StringBuilder arguments = new StringBuilder();
        if (previous.arguments() != null) {
            arguments.append(previous.arguments());
        }
        if (current.arguments() != null) {
            arguments.append(current.arguments());
        }
        return new DeepSeekApi.ChatCompletionMessage.ChatCompletionFunction(name, arguments.toString());
    }

    public boolean isStreamingToolFunctionCall(DeepSeekApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        DeepSeekApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(choice.delta().toolCalls());
    }

    public boolean isStreamingToolFunctionCallFinish(DeepSeekApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        DeepSeekApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return choice.finishReason() == DeepSeekApi.ChatCompletionFinishReason.TOOL_CALLS;
    }
}

