/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.annotation.spring.scan;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractMcpAnnotatedBeans;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractAnnotatedMethodBeanPostProcessor
implements BeanPostProcessor {
    private final AbstractMcpAnnotatedBeans registry;
    private final Set<Class<? extends Annotation>> targetAnnotations;

    public AbstractAnnotatedMethodBeanPostProcessor(AbstractMcpAnnotatedBeans registry, Set<Class<? extends Annotation>> targetAnnotations) {
        Assert.notNull((Object)registry, (String)"AnnotatedBeanRegistry must not be null");
        Assert.notEmpty(targetAnnotations, (String)"Target annotations must not be empty");
        this.registry = registry;
        this.targetAnnotations = targetAnnotations;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanClass = AopUtils.getTargetClass((Object)bean);
        HashSet<Class<? extends Annotation>> foundAnnotations = new HashSet<Class<? extends Annotation>>();
        ReflectionUtils.doWithMethods((Class)beanClass, method -> this.targetAnnotations.forEach(annotationType -> {
            if (AnnotationUtils.findAnnotation((Method)method, (Class)annotationType) != null) {
                foundAnnotations.add((Class<? extends Annotation>)annotationType);
            }
        }));
        if (!foundAnnotations.isEmpty()) {
            this.registry.addMcpAnnotatedBean(bean, foundAnnotations);
        }
        return bean;
    }
}

