/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultToolCallingChatOptions
implements ToolCallingChatOptions {
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    private Set<String> toolNames = new HashSet<String>();
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @Nullable
    private Boolean internalToolExecutionEnabled;
    @Nullable
    private String model;
    @Nullable
    private Double frequencyPenalty;
    @Nullable
    private Integer maxTokens;
    @Nullable
    private Double presencePenalty;
    @Nullable
    private List<String> stopSequences;
    @Nullable
    private Double temperature;
    @Nullable
    private Integer topK;
    @Nullable
    private Double topP;

    @Override
    public List<ToolCallback> getToolCallbacks() {
        return List.copyOf(this.toolCallbacks);
    }

    @Override
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = new ArrayList<ToolCallback>(toolCallbacks);
    }

    @Override
    public Set<String> getToolNames() {
        return Set.copyOf(this.toolNames);
    }

    @Override
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(toolName -> Assert.hasText((String)toolName, (String)"toolNames cannot contain empty elements"));
        this.toolNames = new HashSet<String>(toolNames);
    }

    @Override
    public Map<String, Object> getToolContext() {
        return Map.copyOf(this.toolContext);
    }

    @Override
    public void setToolContext(Map<String, Object> toolContext) {
        Assert.notNull(toolContext, (String)"toolContext cannot be null");
        Assert.noNullElements(toolContext.keySet(), (String)"toolContext cannot contain null keys");
        this.toolContext = new HashMap<String, Object>(toolContext);
    }

    @Override
    @Nullable
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @Override
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    @Override
    @Nullable
    public String getModel() {
        return this.model;
    }

    public void setModel(@Nullable String model) {
        this.model = model;
    }

    @Override
    @Nullable
    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(@Nullable Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @Override
    @Nullable
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(@Nullable Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @Override
    @Nullable
    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(@Nullable Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @Override
    @Nullable
    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(@Nullable List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    @Override
    @Nullable
    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(@Nullable Double temperature) {
        this.temperature = temperature;
    }

    @Override
    @Nullable
    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(@Nullable Integer topK) {
        this.topK = topK;
    }

    @Override
    @Nullable
    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(@Nullable Double topP) {
        this.topP = topP;
    }

    @Override
    public <T extends ChatOptions> T copy() {
        DefaultToolCallingChatOptions options = new DefaultToolCallingChatOptions();
        options.setToolCallbacks(this.getToolCallbacks());
        options.setToolNames(this.getToolNames());
        options.setToolContext(this.getToolContext());
        options.setInternalToolExecutionEnabled(this.getInternalToolExecutionEnabled());
        options.setModel(this.getModel());
        options.setFrequencyPenalty(this.getFrequencyPenalty());
        options.setMaxTokens(this.getMaxTokens());
        options.setPresencePenalty(this.getPresencePenalty());
        options.setStopSequences(this.getStopSequences());
        options.setTemperature(this.getTemperature());
        options.setTopK(this.getTopK());
        options.setTopP(this.getTopP());
        return (T)options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ToolCallingChatOptions.Builder {
        private final DefaultToolCallingChatOptions options = new DefaultToolCallingChatOptions();

        @Override
        public ToolCallingChatOptions.Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.setToolCallbacks(Arrays.asList(toolCallbacks));
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder toolNames(Set<String> toolNames) {
            this.options.setToolNames(toolNames);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(Set.of(toolNames));
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder toolContext(Map<String, Object> context) {
            this.options.setToolContext(context);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder toolContext(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null");
            Assert.notNull((Object)value, (String)"value cannot be null");
            HashMap<String, Object> updatedToolContext = new HashMap<String, Object>(this.options.getToolContext());
            updatedToolContext.put(key, value);
            this.options.setToolContext(updatedToolContext);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder model(@Nullable String model) {
            this.options.setModel(model);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder frequencyPenalty(@Nullable Double frequencyPenalty) {
            this.options.setFrequencyPenalty(frequencyPenalty);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder maxTokens(@Nullable Integer maxTokens) {
            this.options.setMaxTokens(maxTokens);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder presencePenalty(@Nullable Double presencePenalty) {
            this.options.setPresencePenalty(presencePenalty);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder stopSequences(@Nullable List<String> stopSequences) {
            this.options.setStopSequences(stopSequences);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder temperature(@Nullable Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder topK(@Nullable Integer topK) {
            this.options.setTopK(topK);
            return this;
        }

        @Override
        public ToolCallingChatOptions.Builder topP(@Nullable Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        @Override
        public ToolCallingChatOptions build() {
            return this.options;
        }
    }
}

