/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class Address {
    private static final Pattern pattern = Pattern.compile("^([^:]+)://([^/]*)/?(.*)$");
    private final String exchangeType;
    private final String exchangeName;
    private final String routingKey;

    public Address(String address) {
        if (address == null) {
            this.exchangeType = "direct";
            this.exchangeName = "";
            this.routingKey = "";
        } else {
            Matcher matcher = pattern.matcher(address);
            boolean matchFound = matcher.find();
            if (matchFound) {
                this.exchangeType = matcher.group(1);
                this.exchangeName = matcher.group(2);
                this.routingKey = matcher.group(3);
            } else {
                this.exchangeType = "direct";
                this.exchangeName = "";
                this.routingKey = address;
            }
        }
    }

    public Address(String exchangeType, String exchangeName, String routingKey) {
        this.exchangeType = exchangeType;
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.exchangeType + "://" + this.exchangeName + "/");
        if (StringUtils.hasText((String)this.routingKey)) {
            sb.append(this.routingKey);
        }
        return sb.toString();
    }
}

