/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.core.step.item.FaultTolerantChunkProcessor;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.integration.chunk.ChunkHandler;
import org.springframework.batch.integration.chunk.ChunkMessageChannelItemWriter;
import org.springframework.batch.integration.chunk.ChunkProcessorChunkHandler;
import org.springframework.batch.integration.chunk.StepContributionSource;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.PassThroughItemProcessor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteChunkHandlerFactoryBean<T>
implements FactoryBean<ChunkHandler<T>> {
    private static Log logger = LogFactory.getLog(RemoteChunkHandlerFactoryBean.class);
    private TaskletStep step;
    private ItemWriter<T> chunkWriter;
    private StepContributionSource stepContributionSource;

    public void setStep(TaskletStep step) {
        this.step = step;
    }

    public void setChunkWriter(ItemWriter<T> chunkWriter) {
        this.chunkWriter = chunkWriter;
    }

    public void setStepContributionSource(StepContributionSource stepContributionSource) {
        this.stepContributionSource = stepContributionSource;
    }

    public Class<?> getObjectType() {
        return ChunkHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ChunkHandler<T> getObject() throws Exception {
        if (this.stepContributionSource == null) {
            Assert.state((boolean)(this.chunkWriter instanceof StepContributionSource), (String)"The chunk writer must be a StepContributionSource or else the source must be provided explicitly");
            this.stepContributionSource = (StepContributionSource)this.chunkWriter;
        }
        Assert.state((boolean)(this.step instanceof TaskletStep), (String)("Step [" + this.step.getName() + "] must be a TaskletStep"));
        logger.debug((Object)("Converting TaskletStep with name=" + this.step.getName()));
        Tasklet tasklet = this.getTasklet(this.step);
        Assert.state((boolean)(tasklet instanceof ChunkOrientedTasklet), (String)("Tasklet must be ChunkOrientedTasklet in step=" + this.step.getName()));
        ChunkProcessor<T> chunkProcessor = this.getChunkProcessor((ChunkOrientedTasklet)tasklet);
        Assert.state((chunkProcessor != null ? 1 : 0) != 0, (String)("ChunkProcessor must be accessible in Tasklet in step=" + this.step.getName()));
        ItemWriter<T> itemWriter = this.getItemWriter(chunkProcessor);
        Assert.state((!(itemWriter instanceof ChunkMessageChannelItemWriter) ? 1 : 0) != 0, (String)("Cannot adapt step [" + this.step.getName() + "] because it already has a remote chunk writer.  Use a local writer in the step."));
        this.replaceChunkProcessor((ChunkOrientedTasklet)tasklet, this.chunkWriter, this.stepContributionSource);
        if (this.chunkWriter instanceof StepExecutionListener) {
            this.step.registerStepExecutionListener((StepExecutionListener)this.chunkWriter);
        }
        ChunkProcessorChunkHandler<T> handler = new ChunkProcessorChunkHandler<T>();
        this.setNonBuffering(chunkProcessor);
        handler.setChunkProcessor(chunkProcessor);
        handler.afterPropertiesSet();
        return handler;
    }

    private void setNonBuffering(ChunkProcessor<T> chunkProcessor) {
        if (chunkProcessor instanceof FaultTolerantChunkProcessor) {
            ((FaultTolerantChunkProcessor)chunkProcessor).setBuffering(false);
        }
    }

    private void replaceChunkProcessor(ChunkOrientedTasklet<?> tasklet, ItemWriter<T> chunkWriter, final StepContributionSource stepContributionSource) {
        RemoteChunkHandlerFactoryBean.setField(tasklet, "chunkProcessor", new SimpleChunkProcessor<T, T>((ItemProcessor)new PassThroughItemProcessor(), chunkWriter){

            protected void write(StepContribution contribution, Chunk<T> inputs, Chunk<T> outputs) throws Exception {
                this.doWrite(outputs.getItems());
                RemoteChunkHandlerFactoryBean.this.updateStepContribution(contribution, stepContributionSource);
            }
        });
    }

    protected void updateStepContribution(StepContribution contribution, StepContributionSource stepContributionSource) {
        for (StepContribution result : stepContributionSource.getStepContributions()) {
            int i;
            contribution.incrementFilterCount(result.getFilterCount());
            contribution.incrementWriteCount(result.getWriteCount());
            for (i = 0; i < result.getProcessSkipCount(); ++i) {
                contribution.incrementProcessSkipCount();
            }
            for (i = 0; i < result.getWriteSkipCount(); ++i) {
                contribution.incrementWriteSkipCount();
            }
            contribution.setExitStatus(contribution.getExitStatus().and(result.getExitStatus()));
        }
    }

    private ItemWriter<T> getItemWriter(ChunkProcessor<T> chunkProcessor) {
        return (ItemWriter)RemoteChunkHandlerFactoryBean.getField(chunkProcessor, "itemWriter");
    }

    private ChunkProcessor<T> getChunkProcessor(ChunkOrientedTasklet<?> tasklet) {
        return (ChunkProcessor)RemoteChunkHandlerFactoryBean.getField(tasklet, "chunkProcessor");
    }

    private Tasklet getTasklet(TaskletStep step) {
        return (Tasklet)RemoteChunkHandlerFactoryBean.getField(step, "tasklet");
    }

    private static Object getField(Object target, String name) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        if (field == null) {
            logger.debug((Object)("Could not find field [" + name + "] on target [" + target + "]"));
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting field [" + name + "] from target [" + target + "]"));
        }
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }

    private static void setField(Object target, String name, Object value) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        if (field == null) {
            throw new IllegalStateException("Could not find field [" + name + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting field [" + name + "] from target [" + target + "]"));
        }
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
    }
}

