/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive;

import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.AccessLevel;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.CloudFoundryAuthorizationException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;

class ReactiveCloudFoundrySecurityService {
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final WebClient webClient;
    private final String cloudControllerUrl;

    ReactiveCloudFoundrySecurityService(WebClient.Builder webClientBuilder, String cloudControllerUrl, boolean skipSslValidation) {
        Assert.notNull((Object)webClientBuilder, (String)"'webClientBuilder' must not be null");
        Assert.notNull((Object)cloudControllerUrl, (String)"'cloudControllerUrl' must not be null");
        if (skipSslValidation) {
            webClientBuilder.clientConnector((ClientHttpConnector)this.buildTrustAllSslConnector());
        }
        this.webClient = webClientBuilder.build();
        this.cloudControllerUrl = cloudControllerUrl;
    }

    protected ReactorClientHttpConnector buildTrustAllSslConnector() {
        HttpClient client = HttpClient.create().secure(spec -> spec.sslContext(this.createSslContextSpec()));
        return new ReactorClientHttpConnector(client);
    }

    private SslProvider.GenericSslContextSpec<?> createSslContextSpec() {
        return Http11SslContextSpec.forClient().configure(builder -> builder.sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE));
    }

    Mono<AccessLevel> getAccessLevel(String token, String applicationId) throws CloudFoundryAuthorizationException {
        String uri = this.getPermissionsUri(applicationId);
        return this.webClient.get().uri(uri, new Object[0]).header("Authorization", new String[]{"bearer " + token}).retrieve().bodyToMono(Map.class).map(this::getAccessLevel).onErrorMap(this::mapError);
    }

    private Throwable mapError(Throwable throwable) {
        if (throwable instanceof WebClientResponseException) {
            WebClientResponseException webClientResponseException = (WebClientResponseException)throwable;
            HttpStatusCode statusCode = webClientResponseException.getStatusCode();
            if (statusCode.equals(HttpStatus.FORBIDDEN)) {
                return new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.ACCESS_DENIED, "Access denied");
            }
            if (statusCode.is4xxClientError()) {
                return new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_TOKEN, "Invalid token", throwable);
            }
        }
        return new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Cloud controller not reachable");
    }

    private AccessLevel getAccessLevel(Map<?, ?> body) {
        if (Boolean.TRUE.equals(body.get("read_sensitive_data"))) {
            return AccessLevel.FULL;
        }
        return AccessLevel.RESTRICTED;
    }

    private String getPermissionsUri(String applicationId) {
        return this.cloudControllerUrl + "/v2/apps/" + applicationId + "/permissions";
    }

    Mono<Map<String, String>> fetchTokenKeys() {
        return this.getUaaUrl().flatMap(this::fetchTokenKeys);
    }

    private Mono<? extends Map<String, String>> fetchTokenKeys(String url) {
        WebClient.RequestHeadersSpec uri = this.webClient.get().uri(url + "/token_keys", new Object[0]);
        return uri.retrieve().bodyToMono(STRING_OBJECT_MAP).map(this::extractTokenKeys).onErrorMap(ex -> new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, ex.getMessage()));
    }

    private Map<String, String> extractTokenKeys(Map<String, Object> response) {
        HashMap<String, String> tokenKeys = new HashMap<String, String>();
        for (Object key : (List)response.get("keys")) {
            Map tokenKey = (Map)key;
            tokenKeys.put((String)tokenKey.get("kid"), (String)tokenKey.get("value"));
        }
        return tokenKeys;
    }

    Mono<String> getUaaUrl() {
        return this.webClient.get().uri(this.cloudControllerUrl + "/info", new Object[0]).retrieve().bodyToMono(Map.class).map(response -> (String)response.get("token_endpoint")).cache().onErrorMap(ex -> new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Unable to fetch token keys from UAA."));
    }
}

