/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import org.springframework.util.Assert;

@FunctionalInterface
public interface SpanProcessors
extends Iterable<SpanProcessor> {
    public List<SpanProcessor> list();

    @Override
    default public Iterator<SpanProcessor> iterator() {
        return this.list().iterator();
    }

    @Override
    default public Spliterator<SpanProcessor> spliterator() {
        return this.list().spliterator();
    }

    public static SpanProcessors of(SpanProcessor ... spanProcessors) {
        return SpanProcessors.of(Arrays.asList(spanProcessors));
    }

    public static SpanProcessors of(Collection<? extends SpanProcessor> spanProcessors) {
        Assert.notNull(spanProcessors, (String)"'spanProcessors' must not be null");
        List<? extends SpanProcessor> copy = List.copyOf(spanProcessors);
        return () -> copy;
    }
}

