/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricsFilter;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.HandlerMapping;

@Configuration
@ConditionalOnBean(value={CounterService.class, GaugeService.class})
@ConditionalOnClass(value={Servlet.class, ServletRegistration.class, OncePerRequestFilter.class, HandlerMapping.class})
@AutoConfigureAfter(value={MetricRepositoryAutoConfiguration.class})
@ConditionalOnProperty(name={"endpoints.metrics.filter.enabled"}, matchIfMissing=true)
public class MetricFilterAutoConfiguration {
    @Autowired
    private CounterService counterService;
    @Autowired
    private GaugeService gaugeService;

    @Bean
    public Filter metricFilter() {
        return new MetricsFilter(this.counterService, this.gaugeService);
    }
}

