/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;

public class DefaultGaugeService
implements GaugeService {
    private final MetricWriter writer;

    public DefaultGaugeService(MetricWriter writer) {
        this.writer = writer;
    }

    @Override
    public void submit(String metricName, double value) {
        this.writer.set(new Metric<Double>(this.wrap(metricName), value));
    }

    private String wrap(String metricName) {
        if (metricName.startsWith("gauge") || metricName.startsWith("histogram") || metricName.startsWith("timer")) {
            return metricName;
        }
        return "gauge." + metricName;
    }
}

