/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;

public class DropwizardMetricWriter
implements MetricWriter {
    private final MetricRegistry registry;
    private final ConcurrentMap<String, Object> gaugeLocks = new ConcurrentHashMap<String, Object>();

    public DropwizardMetricWriter(MetricRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void increment(Delta<?> delta) {
        String name = delta.getName();
        long value = ((Number)delta.getValue()).longValue();
        if (name.startsWith("meter")) {
            Meter meter = this.registry.meter(name);
            meter.mark(value);
        } else {
            Counter counter = this.registry.counter(name);
            counter.inc(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Metric<?> value) {
        String name = value.getName();
        if (name.startsWith("histogram")) {
            long longValue = ((Number)value.getValue()).longValue();
            Histogram metric = this.registry.histogram(name);
            metric.update(longValue);
        } else if (name.startsWith("timer")) {
            long longValue = ((Number)value.getValue()).longValue();
            Timer metric = this.registry.timer(name);
            metric.update(longValue, TimeUnit.MILLISECONDS);
        } else {
            double gauge = ((Number)value.getValue()).doubleValue();
            Object object = this.getGuageLock(name);
            synchronized (object) {
                this.registry.remove(name);
                this.registry.register(name, (com.codahale.metrics.Metric)new SimpleGauge(gauge));
            }
        }
    }

    private Object getGuageLock(String name) {
        Object lock = this.gaugeLocks.get(name);
        if (lock == null) {
            Object newLock = new Object();
            lock = this.gaugeLocks.putIfAbsent(name, newLock);
            lock = lock == null ? newLock : lock;
        }
        return lock;
    }

    @Override
    public void reset(String metricName) {
        this.registry.remove(metricName);
    }

    private static class SimpleGauge
    implements Gauge<Double> {
        private final double value;

        private SimpleGauge(double value) {
            this.value = value;
        }

        public Double getValue() {
            return this.value;
        }
    }
}

