/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.Properties;
import org.jolokia.http.AgentServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.JolokiaProperties;
import org.springframework.boot.actuate.autoconfigure.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.actuate.endpoint.mvc.JolokiaMvcEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={AgentServlet.class})
@Conditional(value={JolokiaCondition.class})
@AutoConfigureBefore(value={ManagementWebSecurityAutoConfiguration.class})
@AutoConfigureAfter(value={EmbeddedServletContainerAutoConfiguration.class})
@EnableConfigurationProperties(value={JolokiaProperties.class})
public class JolokiaAutoConfiguration {
    @Autowired
    JolokiaProperties properties = new JolokiaProperties();

    @Bean
    @ConditionalOnMissingBean
    public JolokiaMvcEndpoint jolokiaEndpoint() {
        JolokiaMvcEndpoint endpoint = new JolokiaMvcEndpoint();
        endpoint.setInitParameters(this.getInitParameters());
        return endpoint;
    }

    private Properties getInitParameters() {
        Properties initParameters = new Properties();
        initParameters.putAll(this.properties.getConfig());
        return initParameters;
    }

    static class JolokiaCondition
    extends SpringBootCondition {
        JolokiaCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean endpointsEnabled = this.isEnabled(context, "endpoints.", true);
            boolean enabled = this.isEnabled(context, "endpoints.jolokia.", endpointsEnabled);
            return new ConditionOutcome(enabled, "Jolokia enabled");
        }

        private boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), prefix);
            return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)defaultValue);
        }
    }
}

