/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.jmx;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.jmx.DefaultMetricNamingStrategy;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;

@ManagedResource(description="MetricWriter for pushing metrics to JMX MBeans.")
public class JmxMetricWriter
implements MetricWriter {
    private static Log logger = LogFactory.getLog(JmxMetricWriter.class);
    private final ConcurrentMap<String, MetricValue> values = new ConcurrentHashMap<String, MetricValue>();
    private final MBeanExporter exporter;
    private ObjectNamingStrategy namingStrategy = new DefaultMetricNamingStrategy();
    private String domain = "org.springframework.metrics";

    public JmxMetricWriter(MBeanExporter exporter) {
        this.exporter = exporter;
    }

    public void setNamingStrategy(ObjectNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @ManagedOperation
    public void increment(String name, long value) {
        this.increment(new Delta<Long>(name, value));
    }

    @Override
    public void increment(Delta<?> delta) {
        MetricValue counter = this.getValue(delta.getName());
        counter.increment(((Number)delta.getValue()).longValue());
    }

    @ManagedOperation
    public void set(String name, double value) {
        this.set(new Metric<Double>(name, value));
    }

    @Override
    public void set(Metric<?> value) {
        MetricValue metric = this.getValue(value.getName());
        metric.setValue(((Number)value.getValue()).doubleValue());
    }

    @Override
    @ManagedOperation
    public void reset(String name) {
        MetricValue value = (MetricValue)this.values.remove(name);
        if (value != null) {
            try {
                this.exporter.unregisterManagedResource(this.getName(name, value));
            }
            catch (MalformedObjectNameException ex) {
                logger.warn((Object)("Could not unregister MBean for " + name));
            }
        }
    }

    private MetricValue getValue(String name) {
        if (!this.values.containsKey(name)) {
            this.values.putIfAbsent(name, new MetricValue());
            MetricValue value = (MetricValue)this.values.get(name);
            try {
                this.exporter.registerManagedResource((Object)value, this.getName(name, value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (MetricValue)this.values.get(name);
    }

    private ObjectName getName(String name, MetricValue value) throws MalformedObjectNameException {
        String key = String.format(this.domain + ":type=MetricValue,name=%s", name);
        return this.namingStrategy.getObjectName((Object)value, key);
    }

    @ManagedResource
    public static class MetricValue {
        private double value;
        private long lastUpdated = 0L;

        public void setValue(double value) {
            if (this.value != value) {
                this.lastUpdated = System.currentTimeMillis();
            }
            this.value = value;
        }

        public void increment(long value) {
            this.lastUpdated = System.currentTimeMillis();
            this.value += (double)value;
        }

        @ManagedAttribute
        public double getValue() {
            return this.value;
        }

        @ManagedAttribute
        public Date getLastUpdated() {
            return new Date(this.lastUpdated);
        }
    }
}

