/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.HashSet;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.util.StringUtils;

class LinksEnhancer {
    private final String rootPath;
    private final MvcEndpoints endpoints;

    LinksEnhancer(String rootPath, MvcEndpoints endpoints) {
        this.rootPath = rootPath;
        this.endpoints = endpoints;
    }

    public void addEndpointLinks(ResourceSupport resource, String self) {
        if (!resource.hasLink("self")) {
            resource.add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(LinksEnhancer.class).slash((Object)(this.rootPath + self))).withSelfRel());
        }
        HashSet<String> added = new HashSet<String>();
        for (MvcEndpoint mvcEndpoint : this.endpoints.getEndpoints()) {
            if (!mvcEndpoint.getPath().equals(self) && !added.contains(mvcEndpoint.getPath())) {
                this.addEndpointLink(resource, mvcEndpoint);
            }
            added.add(mvcEndpoint.getPath());
        }
    }

    private void addEndpointLink(ResourceSupport resource, MvcEndpoint endpoint) {
        String rel;
        Class type = endpoint.getEndpointType();
        type = type == null ? Object.class : type;
        String path = endpoint.getPath();
        String string = rel = path.startsWith("/") ? path.substring(1) : path;
        if (StringUtils.hasText((String)rel)) {
            String fullPath = this.rootPath + endpoint.getPath();
            resource.add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(type).slash((Object)fullPath)).withRel(rel));
        }
    }
}

