/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.export.AbstractMetricExporter;
import org.springframework.boot.actuate.metrics.rich.RichGauge;
import org.springframework.boot.actuate.metrics.rich.RichGaugeReader;
import org.springframework.boot.actuate.metrics.writer.PrefixMetricWriter;

public class RichGaugeExporter
extends AbstractMetricExporter {
    private static final String MIN = ".min";
    private static final String MAX = ".max";
    private static final String COUNT = ".count";
    private static final String VALUE = ".val";
    private static final String AVG = ".avg";
    private static final String ALPHA = ".alpha";
    private final RichGaugeReader reader;
    private final PrefixMetricWriter writer;

    public RichGaugeExporter(RichGaugeReader reader, PrefixMetricWriter writer) {
        this(reader, writer, "");
    }

    public RichGaugeExporter(RichGaugeReader reader, PrefixMetricWriter writer, String prefix) {
        super(prefix);
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    protected Iterable<Metric<?>> next(String group) {
        RichGauge rich = this.reader.findOne(group);
        ArrayList metrics = new ArrayList();
        metrics.add(new Metric<Double>(group + MIN, rich.getMin()));
        metrics.add(new Metric<Double>(group + MAX, rich.getMax()));
        metrics.add(new Metric<Long>(group + COUNT, rich.getCount()));
        metrics.add(new Metric<Double>(group + VALUE, rich.getValue()));
        metrics.add(new Metric<Double>(group + AVG, rich.getAverage()));
        metrics.add(new Metric<Double>(group + ALPHA, rich.getAlpha()));
        return metrics;
    }

    @Override
    protected Iterable<String> groups() {
        HashSet<String> names = new HashSet<String>();
        for (RichGauge rich : this.reader.findAll()) {
            names.add(rich.getName());
        }
        return names;
    }

    @Override
    protected void write(String group, Collection<Metric<?>> values) {
        this.writer.set(group, values);
    }
}

