/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.Map;
import org.springframework.boot.actuate.endpoint.LoggersEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.ActuatorGetMapping;
import org.springframework.boot.actuate.endpoint.mvc.ActuatorPostMapping;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.boot.actuate.endpoint.mvc.HypermediaDisabled;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.logging.LogLevel;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@ConfigurationProperties(prefix="endpoints.loggers")
public class LoggersMvcEndpoint
extends EndpointMvcAdapter {
    private final LoggersEndpoint delegate;

    public LoggersMvcEndpoint(LoggersEndpoint delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @ActuatorGetMapping(value={"/{name:.*}"})
    @ResponseBody
    @HypermediaDisabled
    public Object get(@PathVariable String name) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        LoggersEndpoint.LoggerLevels levels = this.delegate.invoke(name);
        return levels == null ? ResponseEntity.notFound().build() : levels;
    }

    @ActuatorPostMapping(value={"/{name:.*}"})
    @ResponseBody
    @HypermediaDisabled
    public Object set(@PathVariable String name, @RequestBody Map<String, String> configuration) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        String level = configuration.get("configuredLevel");
        LogLevel logLevel = level == null ? null : LogLevel.valueOf((String)level.toUpperCase());
        this.delegate.setLogLevel(name, logLevel);
        return HttpEntity.EMPTY;
    }
}

