/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="endpoints.health")
public class HealthEndpoint
extends AbstractEndpoint<Health> {
    private final HealthIndicator healthIndicator;
    private long timeToLive = 1000L;

    public HealthEndpoint(HealthAggregator healthAggregator, Map<String, HealthIndicator> healthIndicators) {
        super("health", false);
        Assert.notNull((Object)healthAggregator, (String)"HealthAggregator must not be null");
        Assert.notNull(healthIndicators, (String)"HealthIndicators must not be null");
        CompositeHealthIndicator healthIndicator = new CompositeHealthIndicator(healthAggregator);
        for (Map.Entry<String, HealthIndicator> entry : healthIndicators.entrySet()) {
            healthIndicator.addHealthIndicator(this.getKey(entry.getKey()), entry.getValue());
        }
        this.healthIndicator = healthIndicator;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long ttl) {
        this.timeToLive = ttl;
    }

    @Override
    public Health invoke() {
        return this.healthIndicator.health();
    }

    private String getKey(String name) {
        int index = name.toLowerCase().indexOf("healthindicator");
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }
}

