/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;

public class CompositeMetricReader
implements MetricReader {
    private final List<MetricReader> readers = new ArrayList<MetricReader>();

    public CompositeMetricReader(MetricReader ... readers) {
        Collections.addAll(this.readers, readers);
    }

    @Override
    public Metric<?> findOne(String metricName) {
        for (MetricReader delegate : this.readers) {
            Metric<?> value = delegate.findOne(metricName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        ArrayList values = new ArrayList((int)this.count());
        for (MetricReader delegate : this.readers) {
            Iterable<Metric<?>> all = delegate.findAll();
            for (Metric<?> value : all) {
                values.add(value);
            }
        }
        return values;
    }

    @Override
    public long count() {
        long count = 0L;
        for (MetricReader delegate : this.readers) {
            count += delegate.count();
        }
        return count;
    }
}

