/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

public class HttpMessageConverters
implements Iterable<HttpMessageConverter<?>> {
    private final List<HttpMessageConverter<?>> converters;

    public HttpMessageConverters(HttpMessageConverter<?> ... additionalConverters) {
        this(Arrays.asList(additionalConverters));
    }

    public HttpMessageConverters(Collection<HttpMessageConverter<?>> additionalConverters) {
        ArrayList<Object> converters = new ArrayList<Object>();
        ArrayList processing = new ArrayList(additionalConverters);
        for (HttpMessageConverter<?> defaultConverter : this.getDefaultConverters()) {
            Iterator iterator = processing.iterator();
            while (iterator.hasNext()) {
                HttpMessageConverter candidate = (HttpMessageConverter)iterator.next();
                if (!ClassUtils.isAssignableValue(defaultConverter.getClass(), (Object)candidate)) continue;
                converters.add(candidate);
                iterator.remove();
            }
            converters.add(defaultConverter);
        }
        converters.addAll(0, processing);
        this.converters = Collections.unmodifiableList(converters);
    }

    private List<HttpMessageConverter<?>> getDefaultConverters() {
        ArrayList converters = new ArrayList();
        if (ClassUtils.isPresent((String)"org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport", null)) {
            converters.addAll(new WebMvcConfigurationSupport(){

                public List<HttpMessageConverter<?>> defaultMessageConverters() {
                    return super.getMessageConverters();
                }
            }.defaultMessageConverters());
        } else {
            converters.addAll(new RestTemplate().getMessageConverters());
        }
        this.reorderXmlConvertersToEnd(converters);
        return converters;
    }

    private void reorderXmlConvertersToEnd(List<HttpMessageConverter<?>> converters) {
        ArrayList xml = new ArrayList();
        Iterator<HttpMessageConverter<?>> iterator = converters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter<?> converter = iterator.next();
            if (!(converter instanceof AbstractXmlHttpMessageConverter)) continue;
            xml.add(converter);
            iterator.remove();
        }
        converters.addAll(xml);
    }

    @Override
    public Iterator<HttpMessageConverter<?>> iterator() {
        return this.getConverters().iterator();
    }

    public List<HttpMessageConverter<?>> getConverters() {
        return this.converters;
    }
}

