/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.service.connection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactory;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactoryNotFoundException;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsNotFoundException;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;

public class ConnectionDetailsFactories {
    private static final Log logger = LogFactory.getLog(ConnectionDetailsFactories.class);
    private final List<Registration<?, ?>> registrations = new ArrayList();

    public ConnectionDetailsFactories() {
        this(SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)ConnectionDetailsFactory.class.getClassLoader()));
    }

    ConnectionDetailsFactories(SpringFactoriesLoader loader) {
        List factories = loader.load(ConnectionDetailsFactory.class, SpringFactoriesLoader.FailureHandler.logging((Log)logger));
        Stream<Registration> registrations = factories.stream().map(Registration::get);
        registrations.filter(Objects::nonNull).forEach(this.registrations::add);
    }

    public <S> Map<Class<?>, ConnectionDetails> getConnectionDetails(S source, boolean required) throws ConnectionDetailsFactoryNotFoundException, ConnectionDetailsNotFoundException {
        List<Registration<S, ?>> registrations = this.getRegistrations(source, required);
        LinkedHashMap result = new LinkedHashMap();
        for (Registration<S, ?> registration : registrations) {
            Object connectionDetails = registration.factory().getConnectionDetails(source);
            if (connectionDetails == null) continue;
            Class<?> connectionDetailsType = registration.connectionDetailsType();
            ConnectionDetails previous = (ConnectionDetails)result.put(connectionDetailsType, connectionDetails);
            Assert.state((previous == null ? 1 : 0) != 0, () -> "Duplicate connection details supplied for %s".formatted(connectionDetailsType.getName()));
        }
        if (required && result.isEmpty()) {
            throw new ConnectionDetailsNotFoundException(source);
        }
        return Map.copyOf(result);
    }

    <S> List<Registration<S, ?>> getRegistrations(S source, boolean required) {
        Class<?> sourceType = source.getClass();
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration<?, ?> candidate : this.registrations) {
            if (!candidate.sourceType().isAssignableFrom(sourceType)) continue;
            result.add(candidate);
        }
        if (required && result.isEmpty()) {
            throw new ConnectionDetailsFactoryNotFoundException(source);
        }
        result.sort(Comparator.comparing(Registration::factory, AnnotationAwareOrderComparator.INSTANCE));
        return List.copyOf(result);
    }

    record Registration<S, D extends ConnectionDetails>(Class<S> sourceType, Class<D> connectionDetailsType, ConnectionDetailsFactory<S, D> factory) {
        private static <S, D extends ConnectionDetails> Registration<S, D> get(ConnectionDetailsFactory<S, D> factory) {
            ResolvableType type = ResolvableType.forClass(ConnectionDetailsFactory.class, factory.getClass());
            Class[] generics = type.resolveGenerics();
            Class sourceType = generics[0];
            Class connectionDetailsType = generics[1];
            return sourceType != null && connectionDetailsType != null ? new Registration<S, D>(sourceType, connectionDetailsType, factory) : null;
        }
    }
}

