/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.pulsar;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.AutoClusterFailoverBuilder;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.AutoClusterFailover;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.springframework.boot.autoconfigure.pulsar.DeadLetterPolicyMapper;
import org.springframework.boot.autoconfigure.pulsar.PulsarConnectionDetails;
import org.springframework.boot.autoconfigure.pulsar.PulsarProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.reader.PulsarReaderContainerProperties;
import org.springframework.util.StringUtils;

final class PulsarPropertiesMapper {
    private final PulsarProperties properties;

    PulsarPropertiesMapper(PulsarProperties properties) {
        this.properties = properties;
    }

    void customizeClientBuilder(ClientBuilder clientBuilder, PulsarConnectionDetails connectionDetails) {
        PulsarProperties.Client properties = this.properties.getClient();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getConnectionTimeout).to(this.timeoutProperty((arg_0, arg_1) -> ((ClientBuilder)clientBuilder).connectionTimeout(arg_0, arg_1)));
        map.from(properties::getOperationTimeout).to(this.timeoutProperty((arg_0, arg_1) -> ((ClientBuilder)clientBuilder).operationTimeout(arg_0, arg_1)));
        map.from(properties::getLookupTimeout).to(this.timeoutProperty((arg_0, arg_1) -> ((ClientBuilder)clientBuilder).lookupTimeout(arg_0, arg_1)));
        this.customizeAuthentication(properties.getAuthentication(), (arg_0, arg_1) -> ((ClientBuilder)clientBuilder).authentication(arg_0, arg_1));
        this.customizeServiceUrlProviderBuilder(arg_0 -> ((ClientBuilder)clientBuilder).serviceUrl(arg_0), arg_0 -> ((ClientBuilder)clientBuilder).serviceUrlProvider(arg_0), properties, connectionDetails);
    }

    private void customizeServiceUrlProviderBuilder(Consumer<String> serviceUrlConsumer, Consumer<ServiceUrlProvider> serviceUrlProviderConsumer, PulsarProperties.Client properties, PulsarConnectionDetails connectionDetails) {
        PulsarProperties.Failover failoverProperties = properties.getFailover();
        if (failoverProperties.getBackupClusters().isEmpty()) {
            serviceUrlConsumer.accept(connectionDetails.getBrokerUrl());
            return;
        }
        Map<String, Authentication> secondaryAuths = this.getSecondaryAuths(failoverProperties);
        AutoClusterFailover.AutoClusterFailoverBuilderImpl autoClusterFailoverBuilder = new AutoClusterFailover.AutoClusterFailoverBuilderImpl();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(connectionDetails::getBrokerUrl).to(arg_0 -> ((AutoClusterFailoverBuilder)autoClusterFailoverBuilder).primary(arg_0));
        map.from(secondaryAuths::keySet).as(ArrayList::new).to(arg_0 -> ((AutoClusterFailoverBuilder)autoClusterFailoverBuilder).secondary(arg_0));
        map.from(failoverProperties::getFailoverPolicy).to(arg_0 -> ((AutoClusterFailoverBuilder)autoClusterFailoverBuilder).failoverPolicy(arg_0));
        map.from(failoverProperties::getFailOverDelay).to(this.timeoutProperty((arg_0, arg_1) -> ((AutoClusterFailoverBuilder)autoClusterFailoverBuilder).failoverDelay(arg_0, arg_1)));
        map.from(failoverProperties::getSwitchBackDelay).to(this.timeoutProperty((arg_0, arg_1) -> ((AutoClusterFailoverBuilder)autoClusterFailoverBuilder).switchBackDelay(arg_0, arg_1)));
        map.from(failoverProperties::getCheckInterval).to(this.timeoutProperty((arg_0, arg_1) -> ((AutoClusterFailoverBuilder)autoClusterFailoverBuilder).checkInterval(arg_0, arg_1)));
        map.from(secondaryAuths).to(arg_0 -> ((AutoClusterFailoverBuilder)autoClusterFailoverBuilder).secondaryAuthentication(arg_0));
        serviceUrlProviderConsumer.accept(autoClusterFailoverBuilder.build());
    }

    private Map<String, Authentication> getSecondaryAuths(PulsarProperties.Failover properties) {
        LinkedHashMap<String, Authentication> secondaryAuths = new LinkedHashMap<String, Authentication>();
        properties.getBackupClusters().forEach(backupCluster -> {
            PulsarProperties.Authentication authenticationProperties = backupCluster.getAuthentication();
            if (authenticationProperties.getPluginClassName() == null) {
                secondaryAuths.put(backupCluster.getServiceUrl(), null);
            } else {
                this.customizeAuthentication(authenticationProperties, (authPluginClassName, authParams) -> {
                    Authentication authentication = AuthenticationFactory.create((String)authPluginClassName, (String)authParams);
                    secondaryAuths.put(backupCluster.getServiceUrl(), authentication);
                });
            }
        });
        return secondaryAuths;
    }

    void customizeAdminBuilder(PulsarAdminBuilder adminBuilder, PulsarConnectionDetails connectionDetails) {
        PulsarProperties.Admin properties = this.properties.getAdmin();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(connectionDetails::getAdminUrl).to(arg_0 -> ((PulsarAdminBuilder)adminBuilder).serviceHttpUrl(arg_0));
        map.from(properties::getConnectionTimeout).to(this.timeoutProperty((arg_0, arg_1) -> ((PulsarAdminBuilder)adminBuilder).connectionTimeout(arg_0, arg_1)));
        map.from(properties::getReadTimeout).to(this.timeoutProperty((arg_0, arg_1) -> ((PulsarAdminBuilder)adminBuilder).readTimeout(arg_0, arg_1)));
        map.from(properties::getRequestTimeout).to(this.timeoutProperty((arg_0, arg_1) -> ((PulsarAdminBuilder)adminBuilder).requestTimeout(arg_0, arg_1)));
        this.customizeAuthentication(properties.getAuthentication(), (arg_0, arg_1) -> ((PulsarAdminBuilder)adminBuilder).authentication(arg_0, arg_1));
    }

    private void customizeAuthentication(PulsarProperties.Authentication properties, AuthenticationConsumer action) {
        String pluginClassName = properties.getPluginClassName();
        if (StringUtils.hasText((String)pluginClassName)) {
            try {
                action.accept(pluginClassName, this.getAuthenticationParamsJson(properties.getParam()));
            }
            catch (PulsarClientException.UnsupportedAuthenticationException ex) {
                throw new IllegalStateException("Unable to configure Pulsar authentication", ex);
            }
        }
    }

    private String getAuthenticationParamsJson(Map<String, String> params) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(params);
        try {
            return ObjectMapperFactory.create().writeValueAsString(sortedParams);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not convert auth parameters to encoded string", ex);
        }
    }

    <T> void customizeProducerBuilder(ProducerBuilder<T> producerBuilder) {
        PulsarProperties.Producer properties = this.properties.getProducer();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getName).to(arg_0 -> producerBuilder.producerName(arg_0));
        map.from(properties::getTopicName).to(arg_0 -> producerBuilder.topic(arg_0));
        map.from(properties::getSendTimeout).to(this.timeoutProperty((arg_0, arg_1) -> producerBuilder.sendTimeout(arg_0, arg_1)));
        map.from(properties::getMessageRoutingMode).to(arg_0 -> producerBuilder.messageRoutingMode(arg_0));
        map.from(properties::getHashingScheme).to(arg_0 -> producerBuilder.hashingScheme(arg_0));
        map.from(properties::isBatchingEnabled).to(arg_0 -> producerBuilder.enableBatching(arg_0));
        map.from(properties::isChunkingEnabled).to(arg_0 -> producerBuilder.enableChunking(arg_0));
        map.from(properties::getCompressionType).to(arg_0 -> producerBuilder.compressionType(arg_0));
        map.from(properties::getAccessMode).to(arg_0 -> producerBuilder.accessMode(arg_0));
    }

    <T> void customizeConsumerBuilder(ConsumerBuilder<T> consumerBuilder) {
        PulsarProperties.Consumer properties = this.properties.getConsumer();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getName).to(arg_0 -> consumerBuilder.consumerName(arg_0));
        map.from(properties::getTopics).as(ArrayList::new).to(arg_0 -> consumerBuilder.topics(arg_0));
        map.from(properties::getTopicsPattern).to(arg_0 -> consumerBuilder.topicsPattern(arg_0));
        map.from(properties::getPriorityLevel).to(arg_0 -> consumerBuilder.priorityLevel(arg_0));
        map.from(properties::isReadCompacted).to(arg_0 -> consumerBuilder.readCompacted(arg_0));
        map.from(properties::getDeadLetterPolicy).as(DeadLetterPolicyMapper::map).to(arg_0 -> consumerBuilder.deadLetterPolicy(arg_0));
        map.from(properties::isRetryEnable).to(arg_0 -> consumerBuilder.enableRetry(arg_0));
        this.customizeConsumerBuilderSubscription(consumerBuilder);
    }

    private void customizeConsumerBuilderSubscription(ConsumerBuilder<?> consumerBuilder) {
        PulsarProperties.Consumer.Subscription properties = this.properties.getConsumer().getSubscription();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getName).to(arg_0 -> consumerBuilder.subscriptionName(arg_0));
        map.from(properties::getInitialPosition).to(arg_0 -> consumerBuilder.subscriptionInitialPosition(arg_0));
        map.from(properties::getMode).to(arg_0 -> consumerBuilder.subscriptionMode(arg_0));
        map.from(properties::getTopicsMode).to(arg_0 -> consumerBuilder.subscriptionTopicsMode(arg_0));
        map.from(properties::getType).to(arg_0 -> consumerBuilder.subscriptionType(arg_0));
    }

    void customizeContainerProperties(PulsarContainerProperties containerProperties) {
        this.customizePulsarContainerConsumerSubscriptionProperties(containerProperties);
        this.customizePulsarContainerListenerProperties(containerProperties);
    }

    private void customizePulsarContainerConsumerSubscriptionProperties(PulsarContainerProperties containerProperties) {
        PulsarProperties.Consumer.Subscription properties = this.properties.getConsumer().getSubscription();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getType).to(arg_0 -> ((PulsarContainerProperties)containerProperties).setSubscriptionType(arg_0));
    }

    private void customizePulsarContainerListenerProperties(PulsarContainerProperties containerProperties) {
        PulsarProperties.Listener properties = this.properties.getListener();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getSchemaType).to(arg_0 -> ((PulsarContainerProperties)containerProperties).setSchemaType(arg_0));
        map.from(properties::isObservationEnabled).to(arg_0 -> ((PulsarContainerProperties)containerProperties).setObservationEnabled(arg_0));
    }

    <T> void customizeReaderBuilder(ReaderBuilder<T> readerBuilder) {
        PulsarProperties.Reader properties = this.properties.getReader();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getName).to(arg_0 -> readerBuilder.readerName(arg_0));
        map.from(properties::getTopics).to(arg_0 -> readerBuilder.topics(arg_0));
        map.from(properties::getSubscriptionName).to(arg_0 -> readerBuilder.subscriptionName(arg_0));
        map.from(properties::getSubscriptionRolePrefix).to(arg_0 -> readerBuilder.subscriptionRolePrefix(arg_0));
        map.from(properties::isReadCompacted).to(arg_0 -> readerBuilder.readCompacted(arg_0));
    }

    void customizeReaderContainerProperties(PulsarReaderContainerProperties readerContainerProperties) {
        PulsarProperties.Reader properties = this.properties.getReader();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getTopics).to(arg_0 -> ((PulsarReaderContainerProperties)readerContainerProperties).setTopics(arg_0));
    }

    private Consumer<Duration> timeoutProperty(BiConsumer<Integer, TimeUnit> setter) {
        return duration -> setter.accept((int)duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static interface AuthenticationConsumer {
        public void accept(String var1, String var2) throws PulsarClientException.UnsupportedAuthenticationException;
    }
}

