/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageConfig;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class BuildpackLayersMetadata
extends MappedObject {
    private static final String LABEL_NAME = "io.buildpacks.buildpack.layers";
    private final Buildpacks buildpacks = Buildpacks.access$000(this.getNode());

    private BuildpackLayersMetadata(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    BuildpackLayerDetails getBuildpack(String id, String version) {
        return this.buildpacks.getBuildpack(id, version);
    }

    static BuildpackLayersMetadata fromImage(Image image) throws IOException {
        Assert.notNull((Object)image, (String)"Image must not be null");
        return BuildpackLayersMetadata.fromImageConfig(image.getConfig());
    }

    static BuildpackLayersMetadata fromImageConfig(ImageConfig imageConfig) throws IOException {
        Assert.notNull((Object)imageConfig, (String)"ImageConfig must not be null");
        String json = imageConfig.getLabels().get(LABEL_NAME);
        Assert.notNull((Object)json, () -> "No 'io.buildpacks.buildpack.layers' label found in image config labels '" + StringUtils.collectionToCommaDelimitedString(imageConfig.getLabels().keySet()) + "'");
        return BuildpackLayersMetadata.fromJson(json);
    }

    static BuildpackLayersMetadata fromJson(String json) throws IOException {
        return BuildpackLayersMetadata.fromJson(SharedObjectMapper.get().readTree(json));
    }

    static BuildpackLayersMetadata fromJson(JsonNode node) {
        return new BuildpackLayersMetadata(node);
    }

    static final class BuildpackLayerDetails
    extends MappedObject {
        private final String name = this.valueAt("/name", String.class);
        private final String homepage = this.valueAt("/homepage", String.class);
        private final String layerDiffId = this.valueAt("/layerDiffID", String.class);

        private BuildpackLayerDetails(JsonNode node) {
            super(node, MethodHandles.lookup());
        }

        String getName() {
            return this.name;
        }

        String getHomepage() {
            return this.homepage;
        }

        String getLayerDiffId() {
            return this.layerDiffId;
        }

        private static BuildpackLayerDetails fromJson(JsonNode node) {
            return new BuildpackLayerDetails(node);
        }
    }

    private static class BuildpackVersions {
        private final Map<String, BuildpackLayerDetails> versions = new HashMap<String, BuildpackLayerDetails>();

        private BuildpackVersions() {
        }

        private BuildpackLayerDetails getBuildpack(String version) {
            return this.versions.get(version);
        }

        private void addBuildpackVersion(String version, BuildpackLayerDetails details) {
            this.versions.put(version, details);
        }

        private static BuildpackVersions fromJson(JsonNode node) {
            BuildpackVersions versions = new BuildpackVersions();
            node.fields().forEachRemaining(field -> versions.addBuildpackVersion((String)field.getKey(), BuildpackLayerDetails.fromJson((JsonNode)field.getValue())));
            return versions;
        }
    }

    private static class Buildpacks {
        private final Map<String, BuildpackVersions> buildpacks = new HashMap<String, BuildpackVersions>();

        private Buildpacks() {
        }

        private BuildpackLayerDetails getBuildpack(String id, String version) {
            if (this.buildpacks.containsKey(id)) {
                return this.buildpacks.get(id).getBuildpack(version);
            }
            return null;
        }

        private void addBuildpackVersions(String id, BuildpackVersions versions) {
            this.buildpacks.put(id, versions);
        }

        private static Buildpacks fromJson(JsonNode node) {
            Buildpacks buildpacks = new Buildpacks();
            node.fields().forEachRemaining(field -> buildpacks.addBuildpackVersions((String)field.getKey(), BuildpackVersions.fromJson((JsonNode)field.getValue())));
            return buildpacks;
        }

        static /* synthetic */ Buildpacks access$000(JsonNode x0) {
            return Buildpacks.fromJson(x0);
        }
    }
}

