/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.springframework.boot.buildpack.platform.build.ApiVersion;
import org.springframework.util.StringUtils;

final class ApiVersions {
    static final ApiVersions SUPPORTED_PLATFORMS = ApiVersions.of(0, IntStream.rangeClosed(3, 12));
    private final ApiVersion[] apiVersions;

    private ApiVersions(ApiVersion ... versions) {
        this.apiVersions = versions;
    }

    ApiVersion findLatestSupported(String ... others) {
        for (int versionsIndex = this.apiVersions.length - 1; versionsIndex >= 0; --versionsIndex) {
            ApiVersion apiVersion = this.apiVersions[versionsIndex];
            for (int otherIndex = others.length - 1; otherIndex >= 0; --otherIndex) {
                ApiVersion other = ApiVersion.parse(others[otherIndex]);
                if (!apiVersion.supports(other)) continue;
                return apiVersion;
            }
        }
        throw new IllegalStateException("Detected platform API versions '" + StringUtils.arrayToCommaDelimitedString((Object[])others) + "' are not included in supported versions '" + this + "'");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiVersions other = (ApiVersions)obj;
        return Arrays.equals(this.apiVersions, other.apiVersions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.apiVersions);
    }

    public String toString() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.apiVersions);
    }

    static ApiVersions parse(String ... values) {
        return new ApiVersions((ApiVersion[])Arrays.stream(values).map(ApiVersion::parse).toArray(ApiVersion[]::new));
    }

    static ApiVersions of(int major, IntStream minorsInclusive) {
        return new ApiVersions((ApiVersion[])minorsInclusive.mapToObj(minor -> ApiVersion.of(major, minor)).toArray(ApiVersion[]::new));
    }
}

