/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.socket;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.channels.CompletionHandler;
import java.nio.file.FileSystemException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class NamedPipeSocket
extends Socket {
    private static final int WAIT_INTERVAL = 100;
    private static final long TIMEOUT = TimeUnit.MILLISECONDS.toNanos(1000L);
    private final AsynchronousFileByteChannel channel;

    NamedPipeSocket(String path) throws IOException {
        this.channel = this.open(path);
    }

    private AsynchronousFileByteChannel open(String path) throws IOException {
        Consumer<String> awaiter = Platform.isWindows() ? new WindowsAwaiter() : new SleepAwaiter();
        long startTime = System.nanoTime();
        while (true) {
            try {
                return new AsynchronousFileByteChannel(AsynchronousFileChannel.open(Paths.get(path, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE));
            }
            catch (FileSystemException ex) {
                if (System.nanoTime() - startTime >= TIMEOUT) {
                    throw ex;
                }
                awaiter.accept(path);
                continue;
            }
            break;
        }
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
    }

    @Override
    public InputStream getInputStream() {
        return Channels.newInputStream(this.channel);
    }

    @Override
    public OutputStream getOutputStream() {
        return Channels.newOutputStream(this.channel);
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public static NamedPipeSocket get(String path) throws IOException {
        return new NamedPipeSocket(path);
    }

    private static class AsynchronousFileByteChannel
    implements AsynchronousByteChannel {
        private final AsynchronousFileChannel fileChannel;

        AsynchronousFileByteChannel(AsynchronousFileChannel fileChannel) {
            this.fileChannel = fileChannel;
        }

        @Override
        public <A> void read(ByteBuffer dst, A attachment, final CompletionHandler<Integer, ? super A> handler) {
            this.fileChannel.read(dst, 0L, attachment, new CompletionHandler<Integer, A>(this){
                final /* synthetic */ AsynchronousFileByteChannel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void completed(Integer read, A attachment) {
                    handler.completed(read > 0 ? read : -1, attachment);
                }

                @Override
                public void failed(Throwable exc, A attachment) {
                    if (exc instanceof AsynchronousCloseException) {
                        handler.completed(-1, attachment);
                        return;
                    }
                    handler.failed(exc, attachment);
                }
            });
        }

        @Override
        public Future<Integer> read(ByteBuffer dst) {
            CompletableFutureHandler future = new CompletableFutureHandler();
            this.fileChannel.read(dst, 0L, null, future);
            return future;
        }

        @Override
        public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
            this.fileChannel.write(src, 0L, attachment, handler);
        }

        @Override
        public Future<Integer> write(ByteBuffer src) {
            return this.fileChannel.write(src, 0L);
        }

        @Override
        public void close() throws IOException {
            this.fileChannel.close();
        }

        @Override
        public boolean isOpen() {
            return this.fileChannel.isOpen();
        }

        private static final class CompletableFutureHandler
        extends CompletableFuture<Integer>
        implements CompletionHandler<Integer, Object> {
            private CompletableFutureHandler() {
            }

            @Override
            public void completed(Integer read, Object attachment) {
                this.complete(read > 0 ? read : -1);
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof AsynchronousCloseException) {
                    this.complete(-1);
                    return;
                }
                this.completeExceptionally(exc);
            }
        }
    }

    private static final class WindowsAwaiter
    implements Consumer<String> {
        private WindowsAwaiter() {
        }

        @Override
        public void accept(String path) {
            Kernel32.INSTANCE.WaitNamedPipe(path, 100);
        }
    }

    private static final class SleepAwaiter
    implements Consumer<String> {
        private SleepAwaiter() {
        }

        @Override
        public void accept(String path) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

