/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.gradle.api.file.FileTreeElement;
import org.springframework.boot.gradle.tasks.bundling.DefaultTimeZoneOffset;
import org.springframework.util.StreamUtils;

class LoaderZipEntries {
    private final Long entryTime;

    LoaderZipEntries(Long entryTime) {
        this.entryTime = entryTime;
    }

    WrittenEntries writeTo(ZipArchiveOutputStream out) throws IOException {
        WrittenEntries written = new WrittenEntries();
        try (ZipInputStream loaderJar = new ZipInputStream(this.getClass().getResourceAsStream("/META-INF/loader/spring-boot-loader.jar"));){
            ZipEntry entry = loaderJar.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory() && !entry.getName().equals("META-INF/")) {
                    this.writeDirectory(new ZipArchiveEntry(entry), out);
                    written.addDirectory(entry);
                } else if (entry.getName().endsWith(".class")) {
                    this.writeClass(new ZipArchiveEntry(entry), loaderJar, out);
                    written.addFile(entry);
                }
                entry = loaderJar.getNextEntry();
            }
        }
        return written;
    }

    private void writeDirectory(ZipArchiveEntry entry, ZipArchiveOutputStream out) throws IOException {
        this.prepareEntry(entry, 16877);
        out.putArchiveEntry((ArchiveEntry)entry);
        out.closeArchiveEntry();
    }

    private void writeClass(ZipArchiveEntry entry, ZipInputStream in, ZipArchiveOutputStream out) throws IOException {
        this.prepareEntry(entry, 33188);
        out.putArchiveEntry((ArchiveEntry)entry);
        this.copy(in, (OutputStream)out);
        out.closeArchiveEntry();
    }

    private void prepareEntry(ZipArchiveEntry entry, int unixMode) {
        if (this.entryTime != null) {
            entry.setTime(DefaultTimeZoneOffset.INSTANCE.removeFrom(this.entryTime));
        }
        entry.setUnixMode(unixMode);
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        StreamUtils.copy((InputStream)in, (OutputStream)out);
    }

    static class WrittenEntries {
        private final Set<String> directories = new LinkedHashSet<String>();
        private final Set<String> files = new LinkedHashSet<String>();

        WrittenEntries() {
        }

        private void addDirectory(ZipEntry entry) {
            this.directories.add(entry.getName());
        }

        private void addFile(ZipEntry entry) {
            this.files.add(entry.getName());
        }

        boolean isWrittenDirectory(FileTreeElement element) {
            Object path = element.getRelativePath().getPathString();
            if (element.isDirectory() && !((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            return this.directories.contains(path);
        }

        Set<String> getFiles() {
            return this.files;
        }
    }
}

