/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.AbstractConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.web.NonEmbeddedServletContainerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=-2147483648)
class ErrorPageFilter
extends AbstractConfigurableEmbeddedServletContainer
implements Filter,
NonEmbeddedServletContainerFactory {
    private static Log logger = LogFactory.getLog(ErrorPageFilter.class);
    private static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    private static final String ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    private static final String ERROR_MESSAGE = "javax.servlet.error.message";
    private static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private String global;
    private final Map<Integer, String> statuses = new HashMap<Integer, String>();
    private final Map<Class<?>, String> exceptions = new HashMap();
    private final Map<Class<?>, Class<?>> subtypes = new HashMap();
    private final OncePerRequestFilter delegate = new OncePerRequestFilter(){

        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
            ErrorPageFilter.this.doFilter(request, response, chain);
        }
    };

    ErrorPageFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.delegate.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.delegate.doFilter(request, response, chain);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ErrorWrapperResponse wrapped = new ErrorWrapperResponse(response);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)wrapped);
            int status = wrapped.getStatus();
            if (status >= 400) {
                this.handleErrorStatus(request, response, status, wrapped.getMessage());
                response.flushBuffer();
            } else if (!request.isAsyncStarted()) {
                response.flushBuffer();
            }
        }
        catch (Throwable ex) {
            this.handleException(request, response, wrapped, ex);
            response.flushBuffer();
        }
    }

    private void handleErrorStatus(HttpServletRequest request, HttpServletResponse response, int status, String message) throws ServletException, IOException {
        String errorPath = this.getErrorPath(this.statuses, status);
        if (errorPath == null) {
            response.sendError(status, message);
            return;
        }
        response.setStatus(status);
        this.setErrorAttributes((ServletRequest)request, status, message);
        request.getRequestDispatcher(errorPath).forward((ServletRequest)request, (ServletResponse)response);
    }

    private void handleException(HttpServletRequest request, HttpServletResponse response, ErrorWrapperResponse wrapped, Throwable ex) throws IOException, ServletException {
        Class<?> type = ex.getClass();
        String errorPath = this.getErrorPath(type);
        if (errorPath == null) {
            this.rethrow(ex);
            return;
        }
        this.setErrorAttributes((ServletRequest)request, 500, ex.getMessage());
        request.setAttribute(ERROR_EXCEPTION, (Object)ex);
        request.setAttribute(ERROR_EXCEPTION_TYPE, (Object)type.getName());
        this.forwardToErrorPage(errorPath, request, (HttpServletResponse)wrapped, ex);
    }

    private void forwardToErrorPage(String path, HttpServletRequest request, HttpServletResponse response, Throwable ex) throws ServletException, IOException {
        if (response.isCommitted()) {
            String message = "Cannot forward to error page for" + request.getRequestURI() + " (response is committed), so this response may have " + "the wrong status code";
            logger.error((Object)message, ex);
            return;
        }
        response.reset();
        response.sendError(500, ex.getMessage());
        request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
    }

    private String getErrorPath(Map<Integer, String> map, Integer status) {
        if (map.containsKey(status)) {
            return map.get(status);
        }
        return this.global;
    }

    private String getErrorPath(Class<?> type) {
        if (this.exceptions.containsKey(type)) {
            return this.exceptions.get(type);
        }
        if (this.subtypes.containsKey(type)) {
            return this.exceptions.get(this.subtypes.get(type));
        }
        Class<?> subtype = type;
        while (subtype != Object.class) {
            if (!this.exceptions.containsKey(subtype = subtype.getSuperclass())) continue;
            this.subtypes.put(subtype, type);
            return this.exceptions.get(subtype);
        }
        return this.global;
    }

    private void setErrorAttributes(ServletRequest request, int status, String message) {
        request.setAttribute(ERROR_STATUS_CODE, (Object)status);
        request.setAttribute(ERROR_MESSAGE, (Object)message);
    }

    private void rethrow(Throwable ex) throws IOException, ServletException {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof ServletException) {
            throw (ServletException)ex;
        }
        throw new IllegalStateException(ex);
    }

    @Override
    public void addErrorPages(ErrorPage ... errorPages) {
        for (ErrorPage errorPage : errorPages) {
            if (errorPage.isGlobal()) {
                this.global = errorPage.getPath();
                continue;
            }
            if (errorPage.getStatus() != null) {
                this.statuses.put(errorPage.getStatus().value(), errorPage.getPath());
                continue;
            }
            this.exceptions.put(errorPage.getException(), errorPage.getPath());
        }
    }

    public void destroy() {
    }

    private static class ErrorWrapperResponse
    extends HttpServletResponseWrapper {
        private int status;
        private String message;

        public ErrorWrapperResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int status) throws IOException {
            this.sendError(status, null);
        }

        public void sendError(int status, String message) throws IOException {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

