/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.validation.MessageInterpolatorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

public class ConfigurationPropertiesBindingPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
EnvironmentAware,
ApplicationContextAware,
InitializingBean,
DisposableBean,
ApplicationListener<ContextRefreshedEvent>,
PriorityOrdered {
    public static final String VALIDATOR_BEAN_NAME = "configurationPropertiesValidator";
    private static final String[] VALIDATOR_CLASSES = new String[]{"javax.validation.Validator", "javax.validation.ValidatorFactory"};
    private static final Log logger = LogFactory.getLog(ConfigurationPropertiesBindingPostProcessor.class);
    private ConfigurationBeanFactoryMetaData beans = new ConfigurationBeanFactoryMetaData();
    private PropertySources propertySources;
    private Validator validator;
    private volatile Validator localValidator;
    private ConversionService conversionService;
    private DefaultConversionService defaultConversionService;
    private BeanFactory beanFactory;
    private Environment environment = new StandardEnvironment();
    private ApplicationContext applicationContext;
    private List<Converter<?, ?>> converters = Collections.emptyList();
    private List<GenericConverter> genericConverters = Collections.emptyList();
    private int order = -2147483647;

    @Autowired(required=false)
    @ConfigurationPropertiesBinding
    public void setConverters(List<Converter<?, ?>> converters) {
        this.converters = converters;
    }

    @Autowired(required=false)
    @ConfigurationPropertiesBinding
    public void setGenericConverters(List<GenericConverter> converters) {
        this.genericConverters = converters;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setPropertySources(PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setBeanMetaDataStore(ConfigurationBeanFactoryMetaData beans) {
        this.beans = beans;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.propertySources == null) {
            this.propertySources = this.deducePropertySources();
        }
        if (this.validator == null) {
            this.validator = this.getOptionalBean(VALIDATOR_BEAN_NAME, Validator.class);
        }
        if (this.conversionService == null) {
            this.conversionService = this.getOptionalBean("conversionService", ConversionService.class);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.freeLocalValidator();
    }

    public void destroy() throws Exception {
        this.freeLocalValidator();
    }

    private void freeLocalValidator() {
        try {
            Validator validator = this.localValidator;
            this.localValidator = null;
            if (validator != null) {
                ((DisposableBean)validator).destroy();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private PropertySources deducePropertySources() {
        PropertySourcesPlaceholderConfigurer configurer = this.getSinglePropertySourcesPlaceholderConfigurer();
        if (configurer != null) {
            return new FlatPropertySources(configurer.getAppliedPropertySources());
        }
        if (this.environment instanceof ConfigurableEnvironment) {
            MutablePropertySources propertySources = ((ConfigurableEnvironment)this.environment).getPropertySources();
            return new FlatPropertySources((PropertySources)propertySources);
        }
        logger.warn((Object)"Unable to obtain PropertySources from PropertySourcesPlaceholderConfigurer or Environment");
        return new MutablePropertySources();
    }

    private PropertySourcesPlaceholderConfigurer getSinglePropertySourcesPlaceholderConfigurer() {
        if (this.beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.beanFactory;
            Map beans = listableBeanFactory.getBeansOfType(PropertySourcesPlaceholderConfigurer.class, false, false);
            if (beans.size() == 1) {
                return (PropertySourcesPlaceholderConfigurer)beans.values().iterator().next();
            }
            if (beans.size() > 1 && logger.isWarnEnabled()) {
                logger.warn((Object)("Multiple PropertySourcesPlaceholderConfigurer beans registered " + beans.keySet() + ", falling back to Environment"));
            }
        }
        return null;
    }

    private <T> T getOptionalBean(String name, Class<T> type) {
        try {
            return (T)this.beanFactory.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), ConfigurationProperties.class);
        if (annotation != null) {
            this.postProcessBeforeInitialization(bean, beanName, annotation);
        }
        if ((annotation = this.beans.findFactoryAnnotation(beanName, ConfigurationProperties.class)) != null) {
            this.postProcessBeforeInitialization(bean, beanName, annotation);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void postProcessBeforeInitialization(Object bean, String beanName, ConfigurationProperties annotation) {
        Object target = bean;
        PropertiesConfigurationFactory<Object> factory = new PropertiesConfigurationFactory<Object>(target);
        factory.setPropertySources(this.propertySources);
        factory.setValidator(this.determineValidator(bean));
        factory.setConversionService(this.conversionService == null ? this.getDefaultConversionService() : this.conversionService);
        if (annotation != null) {
            factory.setIgnoreInvalidFields(annotation.ignoreInvalidFields());
            factory.setIgnoreUnknownFields(annotation.ignoreUnknownFields());
            factory.setExceptionIfInvalid(annotation.exceptionIfInvalid());
            factory.setIgnoreNestedProperties(annotation.ignoreNestedProperties());
            if (StringUtils.hasLength((String)annotation.prefix())) {
                factory.setTargetName(annotation.prefix());
            }
        }
        try {
            factory.bindPropertiesToTarget();
        }
        catch (Exception ex) {
            String targetClass = ClassUtils.getShortName(target.getClass());
            throw new BeanCreationException(beanName, "Could not bind properties to " + targetClass + " (" + this.getAnnotationDetails(annotation) + ")", (Throwable)ex);
        }
    }

    private String getAnnotationDetails(ConfigurationProperties annotation) {
        if (annotation == null) {
            return "";
        }
        StringBuilder details = new StringBuilder();
        details.append("prefix=").append(annotation.prefix());
        details.append(", ignoreInvalidFields=").append(annotation.ignoreInvalidFields());
        details.append(", ignoreUnknownFields=").append(annotation.ignoreUnknownFields());
        details.append(", ignoreNestedProperties=").append(annotation.ignoreNestedProperties());
        return details.toString();
    }

    private Validator determineValidator(Object bean) {
        boolean supportsBean;
        Validator validator = this.getValidator();
        boolean bl = supportsBean = validator != null && validator.supports(bean.getClass());
        if (ClassUtils.isAssignable(Validator.class, bean.getClass())) {
            if (supportsBean) {
                return new ChainingValidator(validator, (Validator)bean);
            }
            return (Validator)bean;
        }
        return supportsBean ? validator : null;
    }

    private Validator getValidator() {
        if (this.validator != null) {
            return this.validator;
        }
        if (this.localValidator == null && this.isJsr303Present()) {
            this.localValidator = new ValidatedLocalValidatorFactoryBean(this.applicationContext);
        }
        return this.localValidator;
    }

    private boolean isJsr303Present() {
        for (String validatorClass : VALIDATOR_CLASSES) {
            if (ClassUtils.isPresent((String)validatorClass, (ClassLoader)this.applicationContext.getClassLoader())) continue;
            return false;
        }
        return true;
    }

    private ConversionService getDefaultConversionService() {
        if (this.defaultConversionService == null) {
            DefaultConversionService conversionService = new DefaultConversionService();
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)this);
            for (Converter<?, ?> converter : this.converters) {
                conversionService.addConverter(converter);
            }
            for (GenericConverter genericConverter : this.genericConverters) {
                conversionService.addConverter(genericConverter);
            }
            this.defaultConversionService = conversionService;
        }
        return this.defaultConversionService;
    }

    private static class FlatPropertySources
    implements PropertySources {
        private PropertySources propertySources;

        FlatPropertySources(PropertySources propertySources) {
            this.propertySources = propertySources;
        }

        public Iterator<PropertySource<?>> iterator() {
            MutablePropertySources result = this.getFlattened();
            return result.iterator();
        }

        public boolean contains(String name) {
            return this.get(name) != null;
        }

        public PropertySource<?> get(String name) {
            return this.getFlattened().get(name);
        }

        private MutablePropertySources getFlattened() {
            MutablePropertySources result = new MutablePropertySources();
            for (PropertySource propertySource : this.propertySources) {
                this.flattenPropertySources(propertySource, result);
            }
            return result;
        }

        private void flattenPropertySources(PropertySource<?> propertySource, MutablePropertySources result) {
            Object source = propertySource.getSource();
            if (source instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment environment = (ConfigurableEnvironment)source;
                for (PropertySource childSource : environment.getPropertySources()) {
                    this.flattenPropertySources(childSource, result);
                }
            } else {
                result.addLast(propertySource);
            }
        }
    }

    private static class ChainingValidator
    implements Validator {
        private Validator[] validators;

        ChainingValidator(Validator ... validators) {
            Assert.notNull((Object)validators, (String)"Validators must not be null");
            this.validators = validators;
        }

        public boolean supports(Class<?> clazz) {
            for (Validator validator : this.validators) {
                if (!validator.supports(clazz)) continue;
                return true;
            }
            return false;
        }

        public void validate(Object target, Errors errors) {
            for (Validator validator : this.validators) {
                if (!validator.supports(target.getClass())) continue;
                validator.validate(target, errors);
            }
        }
    }

    private static class ValidatedLocalValidatorFactoryBean
    extends LocalValidatorFactoryBean {
        private static final Log logger = LogFactory.getLog(ConfigurationPropertiesBindingPostProcessor.class);

        ValidatedLocalValidatorFactoryBean(ApplicationContext applicationContext) {
            this.setApplicationContext(applicationContext);
            this.setMessageInterpolator(new MessageInterpolatorFactory().getObject());
            this.afterPropertiesSet();
        }

        public boolean supports(Class<?> type) {
            if (!super.supports(type)) {
                return false;
            }
            if (AnnotatedElementUtils.hasAnnotation(type, Validated.class)) {
                return true;
            }
            if (type.getPackage() != null && type.getPackage().getName().startsWith("org.springframework.boot")) {
                return false;
            }
            if (this.getConstraintsForClass(type).isBeanConstrained()) {
                logger.warn((Object)("The @ConfigurationProperties bean " + type + " contains validation constraints but had not been annotated with @Validated."));
            }
            return true;
        }
    }
}

