/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonParser;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonProcessingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonToken;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationContext;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonMappingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public class StackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;
    public static final StackTraceElementDeserializer instance = new StackTraceElementDeserializer();

    public StackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            String string = "";
            String string2 = "";
            String string3 = "";
            int n = -1;
            while ((jsonToken = jsonParser.nextValue()) != JsonToken.END_OBJECT) {
                String string4 = jsonParser.getCurrentName();
                if ("className".equals(string4)) {
                    string = jsonParser.getText();
                    continue;
                }
                if ("fileName".equals(string4)) {
                    string3 = jsonParser.getText();
                    continue;
                }
                if ("lineNumber".equals(string4)) {
                    if (jsonToken.isNumeric()) {
                        n = jsonParser.getIntValue();
                        continue;
                    }
                    throw JsonMappingException.from(jsonParser, "Non-numeric token (" + (Object)((Object)jsonToken) + ") for property 'lineNumber'");
                }
                if ("methodName".equals(string4)) {
                    string2 = jsonParser.getText();
                    continue;
                }
                if ("nativeMethod".equals(string4)) continue;
                this.handleUnknownProperty(jsonParser, deserializationContext, this._valueClass, string4);
            }
            return new StackTraceElement(string, string2, string3, n);
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }
}

