/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.client.loadbalancer.AsyncLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.AsyncRestTemplateCustomizer;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.AsyncRestTemplate;

@Configuration
@ConditionalOnBean(value={LoadBalancerClient.class})
@ConditionalOnClass(value={AsyncRestTemplate.class})
public class AsyncLoadBalancerAutoConfiguration {

    @Configuration
    static class LoadBalancerInterceptorConfig {
        LoadBalancerInterceptorConfig() {
        }

        @Bean
        public AsyncLoadBalancerInterceptor asyncLoadBalancerInterceptor(LoadBalancerClient loadBalancerClient) {
            return new AsyncLoadBalancerInterceptor(loadBalancerClient);
        }

        @Bean
        public AsyncRestTemplateCustomizer asyncRestTemplateCustomizer(final AsyncLoadBalancerInterceptor loadBalancerInterceptor) {
            return new AsyncRestTemplateCustomizer(){

                @Override
                public void customize(AsyncRestTemplate restTemplate) {
                    ArrayList<AsyncLoadBalancerInterceptor> list = new ArrayList<AsyncLoadBalancerInterceptor>(restTemplate.getInterceptors());
                    list.add(loadBalancerInterceptor);
                    restTemplate.setInterceptors(list);
                }
            };
        }
    }

    @Configuration
    static class AsyncRestTemplateCustomizerConfig {
        @LoadBalanced
        @Autowired(required=false)
        private List<AsyncRestTemplate> restTemplates = Collections.emptyList();

        AsyncRestTemplateCustomizerConfig() {
        }

        @Bean
        public SmartInitializingSingleton loadBalancedAsyncRestTemplateInitializer(final List<AsyncRestTemplateCustomizer> customizers) {
            return new SmartInitializingSingleton(){

                public void afterSingletonsInstantiated() {
                    for (AsyncRestTemplate restTemplate : restTemplates) {
                        for (AsyncRestTemplateCustomizer customizer : customizers) {
                            customizer.customize(restTemplate);
                        }
                    }
                }
            };
        }
    }
}

