/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.cloud.config.client.ConfigServerBootstrapper;
import org.springframework.cloud.config.client.ConfigServerConfigDataResource;
import org.springframework.cloud.config.client.RetryProperties;
import org.springframework.cloud.config.client.RetryTemplateFactory;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.ClassUtils;

public class ConfigClientRetryBootstrapper
implements BootstrapRegistryInitializer {
    static final boolean RETRY_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.retry.annotation.Retryable", null);

    public void initialize(BootstrapRegistry registry) {
        if (!RETRY_IS_PRESENT) {
            return;
        }
        registry.registerIfAbsent(ConfigServerBootstrapper.LoaderInterceptor.class, context -> loadContext -> {
            ConfigServerConfigDataResource resource = loadContext.getResource();
            if (resource.getProperties().isFailFast()) {
                RetryProperties properties = resource.getRetryProperties();
                RetryTemplate retryTemplate = RetryTemplateFactory.create(properties, resource.getLog());
                return (ConfigData)retryTemplate.execute(retryContext -> {
                    if (resource.getLog().isDebugEnabled()) {
                        resource.getLog().debug((Object)("Retry: count=" + retryContext.getRetryCount()));
                    }
                    return (ConfigData)loadContext.getInvocation().apply(loadContext.getLoaderContext(), resource);
                });
            }
            return (ConfigData)loadContext.getInvocation().apply(loadContext.getLoaderContext(), resource);
        });
    }
}

