/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.DataPolicy;
import org.springframework.core.convert.converter.Converter;

public class DataPolicyConverter
implements Converter<String, DataPolicy> {
    public DataPolicy convert(String policyValue) {
        Policy policy = Policy.getValue(policyValue);
        return policy == null ? null : policy.toDataPolicy();
    }

    static enum Policy {
        DEFAULT,
        EMPTY,
        NORMAL,
        PRELOADED,
        PARTITION,
        PERSISTENT_PARTITION,
        REPLICATE,
        PERSISTENT_REPLICATE;


        private static String toUpperCase(String value) {
            return value == null ? null : value.toUpperCase();
        }

        public static Policy getValue(String value) {
            try {
                return Policy.valueOf(Policy.toUpperCase(value));
            }
            catch (Exception e) {
                return null;
            }
        }

        public DataPolicy toDataPolicy() {
            switch (this) {
                case EMPTY: {
                    return DataPolicy.EMPTY;
                }
                case NORMAL: {
                    return DataPolicy.NORMAL;
                }
                case PRELOADED: {
                    return DataPolicy.PRELOADED;
                }
                case PARTITION: {
                    return DataPolicy.PARTITION;
                }
                case PERSISTENT_PARTITION: {
                    return DataPolicy.PERSISTENT_PARTITION;
                }
                case REPLICATE: {
                    return DataPolicy.REPLICATE;
                }
                case PERSISTENT_REPLICATE: {
                    return DataPolicy.PERSISTENT_REPLICATE;
                }
            }
            return DataPolicy.DEFAULT;
        }
    }
}

