/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionService;
import org.apache.shiro.util.Assert;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.ContinuousQueryListenerContainerConfigurer;
import org.springframework.data.gemfire.config.annotation.EnableContinuousQueries;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.listener.ContinuousQueryDefinition;
import org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer;
import org.springframework.data.gemfire.listener.annotation.ContinuousQuery;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ErrorHandler;
import org.springframework.util.StringUtils;

@Configuration
public class ContinuousQueryConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    protected static final String ORG_SPRINGFRAMEWORK_DATA_GEMFIRE_PACKAGE_NAME = "org.springframework.data.gemfire";
    protected static final String ORG_SPRINGFRAMEWORK_PACKAGE_NAME = "org.springframework";
    private int phase;
    @Autowired(required=false)
    private List<ContinuousQueryListenerContainerConfigurer> configurers = Collections.emptyList();
    private String errorHandlerBeanName;
    private String poolName;
    private String taskExecutorBeanName;

    protected Class getAnnotationType() {
        return EnableContinuousQueries.class;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (importMetadata.hasAnnotation(this.getAnnotationType().getName())) {
            AnnotationAttributes enableContinuousQueriesAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(this.getAnnotationType().getName()));
            this.setErrorHandlerBeanName(enableContinuousQueriesAttributes.getString("errorHandlerBeanName"));
            this.setPhase((Integer)enableContinuousQueriesAttributes.getNumber("phase"));
            this.setPoolName(enableContinuousQueriesAttributes.getString("poolName"));
            this.setTaskExecutorBeanName(enableContinuousQueriesAttributes.getString("taskExecutorBeanName"));
        }
    }

    @Bean
    public BeanPostProcessor continuousQueryBeanPostProcessor() {
        return new BeanPostProcessor(){
            private ContinuousQueryListenerContainer container;
            private List<ContinuousQueryDefinition> continuousQueryDefinitions = new ArrayList<ContinuousQueryDefinition>();

            @Nullable
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof ContinuousQueryListenerContainer) {
                    this.container = (ContinuousQueryListenerContainer)bean;
                    this.continuousQueryDefinitions.forEach(definition -> this.container.addListener((ContinuousQueryDefinition)definition));
                    this.continuousQueryDefinitions.clear();
                } else if (ContinuousQueryConfiguration.this.isApplicationBean(bean)) {
                    List definitions = Arrays.stream(bean.getClass().getMethods()).filter(method -> method.isAnnotationPresent(ContinuousQuery.class)).map(method -> ContinuousQueryDefinition.from(bean, method)).collect(Collectors.toList());
                    Optional.ofNullable(this.container).map(container -> {
                        definitions.forEach(container::addListener);
                        return container;
                    }).orElseGet(() -> {
                        this.continuousQueryDefinitions.addAll(definitions);
                        return null;
                    });
                }
                return bean;
            }
        };
    }

    private boolean isApplicationBean(Object bean) {
        return Optional.ofNullable(bean).map(Object::getClass).filter(type -> type.getPackage().getName().startsWith(ORG_SPRINGFRAMEWORK_DATA_GEMFIRE_PACKAGE_NAME) || !type.getPackage().getName().startsWith(ORG_SPRINGFRAMEWORK_PACKAGE_NAME)).isPresent();
    }

    @Bean
    public ContinuousQueryListenerContainer continuousQueryListenerContainer(GemFireCache gemfireCache) {
        Assert.state((boolean)CacheUtils.isClient(gemfireCache), (String)"Continuous Queries (CQ) may only be used in a ClientCache application");
        ContinuousQueryListenerContainer container = new ContinuousQueryListenerContainer();
        container.setCache((RegionService)gemfireCache);
        container.setContinuousQueryListenerContainerConfigurers(this.resolveContinuousQueryListenerContainerConfigurers());
        this.resolveErrorHandler().ifPresent(container::setErrorHandler);
        this.resolvePhase().ifPresent(container::setPhase);
        this.resolvePoolName().ifPresent(container::setPoolName);
        this.resolveTaskExecutor().ifPresent(container::setTaskExecutor);
        return container;
    }

    protected List<ContinuousQueryListenerContainerConfigurer> resolveContinuousQueryListenerContainerConfigurers() {
        return Optional.ofNullable(this.configurers).filter(configurers -> !configurers.isEmpty()).orElseGet(() -> Optional.of(this.getBeanFactory()).filter(beanFactory -> beanFactory instanceof ListableBeanFactory).map(beanFactory -> {
            Map beansOfType = ((ListableBeanFactory)beanFactory).getBeansOfType(ContinuousQueryListenerContainerConfigurer.class, true, true);
            return CollectionUtils.nullSafeMap(beansOfType).values().stream().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList));
    }

    protected Optional<ErrorHandler> resolveErrorHandler() {
        return Optional.ofNullable(this.getErrorHandlerBeanName()).filter(StringUtils::hasText).map(errorHandlerBeanName -> (ErrorHandler)this.getBeanFactory().getBean(errorHandlerBeanName, ErrorHandler.class));
    }

    protected Optional<Integer> resolvePhase() {
        return Optional.of(this.getPhase()).filter(phase -> phase != 0);
    }

    protected Optional<String> resolvePoolName() {
        return Optional.ofNullable(this.getPoolName()).filter(StringUtils::hasText);
    }

    protected Optional<Executor> resolveTaskExecutor() {
        return Optional.ofNullable(this.getTaskExecutorBeanName()).filter(StringUtils::hasText).map(taskExecutorBeanName -> (Executor)this.getBeanFactory().getBean(taskExecutorBeanName, Executor.class));
    }

    public void setErrorHandlerBeanName(String errorHandlerBeanName) {
        this.errorHandlerBeanName = errorHandlerBeanName;
    }

    protected String getErrorHandlerBeanName() {
        return this.errorHandlerBeanName;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    protected int getPhase() {
        return this.phase;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    protected String getPoolName() {
        return this.poolName;
    }

    public void setTaskExecutorBeanName(String taskExecutorBeanName) {
        this.taskExecutorBeanName = taskExecutorBeanName;
    }

    protected String getTaskExecutorBeanName() {
        return this.taskExecutorBeanName;
    }
}

