/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.pig;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.data.hadoop.pig.PigCallback;
import org.springframework.data.hadoop.pig.PigOperations;
import org.springframework.data.hadoop.pig.PigScript;
import org.springframework.data.hadoop.pig.PigServerFactory;
import org.springframework.data.hadoop.pig.PigUtils;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public class PigTemplate
implements InitializingBean,
PigOperations,
ResourceLoaderAware {
    private PigServerFactory pigServerFactory;
    private ResourceLoader resourceLoader;

    public PigTemplate() {
    }

    public PigTemplate(PigServerFactory pigFactory) {
        this.pigServerFactory = pigFactory;
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.pigServerFactory, (String)"non-null pig server factory required");
    }

    @Override
    public <T> T execute(PigCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"a valid callback is required");
        PigServer pig = this.createPigServer();
        try {
            pig.getPigContext().connect();
            T t = action.doInPig(pig);
            return t;
        }
        catch (ExecException ex) {
            throw this.convertPigAccessException(ex);
        }
        catch (IOException ex) {
            throw this.convertPigAccessException(ex);
        }
        finally {
            pig.shutdown();
        }
    }

    protected DataAccessException convertPigAccessException(IOException ex) {
        return PigUtils.convert(ex);
    }

    protected DataAccessException convertPigAccessException(ExecException ex) {
        return PigUtils.convert((PigException)ex);
    }

    @Override
    public List<ExecJob> executeScript(String script) throws DataAccessException {
        return this.executeScript(script, null);
    }

    @Override
    public List<ExecJob> executeScript(String script, Map<?, ?> arguments) throws DataAccessException {
        Assert.hasText((String)script, (String)"a script is required");
        ByteArrayResource res = null;
        if (ResourceUtils.isUrl((String)script)) {
            if (this.resourceLoader != null) {
                res = this.resourceLoader.getResource(script);
            }
        } else {
            res = new ByteArrayResource(script.getBytes());
        }
        return this.executeScript(new PigScript((Resource)res, arguments));
    }

    @Override
    public List<ExecJob> executeScript(PigScript script) throws DataAccessException {
        return this.executeScript(Collections.singleton(script));
    }

    @Override
    public List<ExecJob> executeScript(final Iterable<PigScript> scripts) throws DataAccessException {
        return this.execute(new PigCallback<List<ExecJob>>(){

            @Override
            public List<ExecJob> doInPig(PigServer pig) throws ExecException, IOException {
                return PigUtils.run(PigTemplate.this.createPigServer(), scripts);
            }
        });
    }

    protected PigServer createPigServer() {
        return this.pigServerFactory.getPigServer();
    }

    public void setPigFactory(PigServerFactory pigServerFactory) {
        this.pigServerFactory = pigServerFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

