/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.NamedEntityGraph;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.DecoratingProxy;
import org.springframework.data.jpa.domain.AbstractAuditable;
import org.springframework.data.jpa.domain.AbstractPersistable;
import org.springframework.data.jpa.domain.support.AuditingBeanFactoryPostProcessor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.query.QueryEnhancerSelector;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.QuerydslJpaPredicateExecutor;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.util.ClassUtils;

class JpaRuntimeHints
implements RuntimeHintsRegistrar {
    JpaRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        hints.proxies().registerJdkProxy(new Class[]{CrudMethodMetadata.class, SpringProxy.class, Advised.class, DecoratingProxy.class});
        if (ClassUtils.isPresent((String)"org.springframework.beans.factory.aspectj.ConfigurableObject", (ClassLoader)classLoader)) {
            hints.reflection().registerType(TypeReference.of((String)"org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect"), hint -> {
                TypeHint.Builder builder = hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS});
            });
            hints.reflection().registerTypes(Arrays.asList(TypeReference.of(AuditingBeanFactoryPostProcessor.class), TypeReference.of(AuditingEntityListener.class)), hint -> {
                TypeHint.Builder builder = hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS});
            });
        }
        hints.reflection().registerType(TypeReference.of(QueryEnhancerSelector.DefaultQueryEnhancerSelector.class), hint -> {
            TypeHint.Builder builder = hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
        });
        hints.reflection().registerType(TypeReference.of(SimpleJpaRepository.class), hint -> {
            TypeHint.Builder builder = hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
        });
        hints.reflection().registerType(Query.class, hint -> {
            TypeHint.Builder builder = hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
        });
        hints.reflection().registerTypes(List.of(TypeReference.of(AbstractPersistable.class), TypeReference.of(AbstractAuditable.class)), hint -> {
            TypeHint.Builder builder = hint.withMembers(new MemberCategory[]{MemberCategory.ACCESS_DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS});
        });
        if (QuerydslUtils.QUERY_DSL_PRESENT) {
            hints.reflection().registerType(QuerydslJpaPredicateExecutor.class, hint -> {
                TypeHint.Builder builder = hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}).onReachableType(QuerydslPredicateExecutor.class);
            });
        }
        hints.reflection().registerType(jakarta.persistence.Query.class, hint -> {
            TypeHint.Builder builder = hint.withMethod("getResultStream", Collections.emptyList(), ExecutableMode.INVOKE);
        });
        hints.reflection().registerType(NamedEntityGraph.class, hint -> {
            TypeHint.Builder builder = hint.onReachableType(EntityGraph.class).withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
        });
        if (ClassUtils.isPresent((String)"org.hibernate.Hibernate", (ClassLoader)classLoader)) {
            hints.reflection().registerType(TypeReference.of((String)"org.hibernate.query.sqm.tree.select.SqmQueryPart[]"), new MemberCategory[]{MemberCategory.UNSAFE_ALLOCATED});
        }
    }
}

