/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.EnableMongoAuditing;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.event.AuditingEventListener;
import org.springframework.util.Assert;

class MongoAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    MongoAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableMongoAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return "mongoAuditingHandler";
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        this.defaultDependenciesIfNecessary(registry, annotationMetadata);
        super.registerBeanDefinitions(annotationMetadata, registry);
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class);
        builder.addConstructorArgReference("mongoMappingContext");
        return this.configureDefaultAuditHandlerAttributes(configuration, builder);
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, (String)"BeanDefinition must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        BeanDefinitionBuilder listenerBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(AuditingEventListener.class);
        listenerBeanDefinitionBuilder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), (Object)registry));
        this.registerInfrastructureBeanWithId(listenerBeanDefinitionBuilder.getBeanDefinition(), AuditingEventListener.class.getName(), registry);
    }

    private void defaultDependenciesIfNecessary(BeanDefinitionRegistry registry, Object source) {
        if (!registry.containsBeanDefinition("mongoMappingContext")) {
            RootBeanDefinition definition = new RootBeanDefinition(MongoMappingContext.class);
            definition.setRole(2);
            definition.setSource(source);
            registry.registerBeanDefinition("mongoMappingContext", (BeanDefinition)definition);
        }
    }
}

