/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.UncategorizedMongoDbException;
import org.springframework.util.ClassUtils;

public class MongoExceptionTranslator
implements PersistenceExceptionTranslator {
    private static final Set<String> DULICATE_KEY_EXCEPTIONS = new HashSet<String>(Arrays.asList("MongoException.DuplicateKey", "DuplicateKeyException"));
    private static final Set<String> RESOURCE_FAILURE_EXCEPTIONS = new HashSet<String>(Arrays.asList("MongoException.Network", "MongoSocketException", "MongoException.CursorNotFound", "MongoCursorNotFoundException", "MongoServerSelectionException", "MongoTimeoutException"));
    private static final Set<String> RESOURCE_USAGE_EXCEPTIONS = new HashSet<String>(Arrays.asList("MongoInternalException"));
    private static final Set<String> DATA_INTEGRETY_EXCEPTIONS = new HashSet<String>(Arrays.asList("WriteConcernException"));

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        String exception = ClassUtils.getShortName((Class)ClassUtils.getUserClass(ex.getClass()));
        if (DULICATE_KEY_EXCEPTIONS.contains(exception)) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (RESOURCE_FAILURE_EXCEPTIONS.contains(exception)) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (RESOURCE_USAGE_EXCEPTIONS.contains(exception)) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (DATA_INTEGRETY_EXCEPTIONS.contains(exception)) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoException) {
            int code = ((MongoException)((Object)ex)).getCode();
            if (code == 11000 || code == 11001) {
                throw new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
            }
            if (code == 12000 || code == 13440) {
                throw new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (code == 10003 || code == 12001 || code == 12010 || code == 12011 || code == 12012) {
                throw new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
            }
            return new UncategorizedMongoDbException(ex.getMessage(), ex);
        }
        return null;
    }
}

