/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Field {
    private final Map<String, Integer> criteria = new HashMap<String, Integer>();
    private final Map<String, Object> slices = new HashMap<String, Object>();
    private final Map<String, Criteria> elemMatchs = new HashMap<String, Criteria>();
    private String postionKey;
    private int positionValue;

    public Field include(String key) {
        this.criteria.put(key, 1);
        return this;
    }

    public Field exclude(String key) {
        this.criteria.put(key, 0);
        return this;
    }

    public Field slice(String key, int size) {
        this.slices.put(key, size);
        return this;
    }

    public Field slice(String key, int offset, int size) {
        this.slices.put(key, new Integer[]{offset, size});
        return this;
    }

    public Field elemMatch(String key, Criteria elemMatchCriteria) {
        this.elemMatchs.put(key, elemMatchCriteria);
        return this;
    }

    public Field position(String field, int value) {
        Assert.hasText((String)field, (String)"DocumentField must not be null or empty!");
        this.postionKey = field;
        this.positionValue = value;
        return this;
    }

    public DBObject getFieldsObject() {
        BasicDBObject dbo = new BasicDBObject();
        for (String string : this.criteria.keySet()) {
            dbo.put(string, (Object)this.criteria.get(string));
        }
        for (String string : this.slices.keySet()) {
            dbo.put(string, (Object)new BasicDBObject("$slice", this.slices.get(string)));
        }
        for (Map.Entry entry : this.elemMatchs.entrySet()) {
            BasicDBObject dbObject = new BasicDBObject("$elemMatch", (Object)((Criteria)entry.getValue()).getCriteriaObject());
            dbo.put((String)entry.getKey(), (Object)dbObject);
        }
        if (this.postionKey != null) {
            dbo.put(this.postionKey + ".$", (Object)this.positionValue);
        }
        return dbo;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Field)) {
            return false;
        }
        Field that = (Field)object;
        if (!this.criteria.equals(that.criteria)) {
            return false;
        }
        if (!this.slices.equals(that.slices)) {
            return false;
        }
        if (!this.elemMatchs.equals(that.elemMatchs)) {
            return false;
        }
        boolean samePositionKey = this.postionKey == null ? that.postionKey == null : this.postionKey.equals(that.postionKey);
        boolean samePositionValue = this.positionValue == that.positionValue;
        return samePositionKey && samePositionValue;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ObjectUtils.nullSafeHashCode(this.criteria);
        result += 31 * ObjectUtils.nullSafeHashCode(this.elemMatchs);
        result += 31 * ObjectUtils.nullSafeHashCode(this.slices);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.postionKey);
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.positionValue);
    }
}

