/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.OpDivide;
import org.springframework.expression.spel.ast.OpMinus;
import org.springframework.expression.spel.ast.OpModulus;
import org.springframework.expression.spel.ast.OpMultiply;
import org.springframework.expression.spel.ast.OpPlus;
import org.springframework.expression.spel.ast.Operator;

public class OperatorNode
extends ExpressionNode {
    private static final Map<String, String> OPERATORS;
    private final Operator operator;

    OperatorNode(Operator node, ExpressionState state) {
        super((SpelNode)node, state);
        this.operator = node;
    }

    @Override
    public boolean isMathematicalOperation() {
        return this.operator instanceof OpMinus || this.operator instanceof OpPlus || this.operator instanceof OpMultiply || this.operator instanceof OpDivide || this.operator instanceof OpModulus;
    }

    public boolean isUnaryOperator() {
        return this.operator.getRightOperand() == null;
    }

    public String getMongoOperator() {
        return OPERATORS.get(this.operator.getOperatorName());
    }

    public boolean isUnaryMinus() {
        return this.isUnaryOperator() && this.operator instanceof OpMinus;
    }

    public ExpressionNode getLeft() {
        return this.from((SpelNode)this.operator.getLeftOperand());
    }

    public ExpressionNode getRight() {
        return this.from((SpelNode)this.operator.getRightOperand());
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put("+", "$add");
        map.put("-", "$subtract");
        map.put("*", "$multiply");
        map.put("/", "$divide");
        map.put("%", "$mod");
        OPERATORS = Collections.unmodifiableMap(map);
    }
}

