/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.graphdb.PropertyContainer;

public class PropertiesMap {
    private final Map<String, Object> values = new HashMap<String, Object>();

    public PropertiesMap(PropertyContainer container) {
        for (String key : container.getPropertyKeys()) {
            this.values.put(key, container.getProperty(key));
        }
    }

    public PropertiesMap(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.values.put(entry.getKey(), PropertiesMap.toInternalType(entry.getValue()));
        }
    }

    public Object getValue(String key) {
        return this.values.get(key);
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            result.put(entry.getKey(), this.toSerializedType(entry.getValue()));
        }
        return result;
    }

    void storeTo(PropertyContainer container) {
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            container.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static Object toInternalType(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return new byte[0];
            }
            Object first = list.get(0);
            if (first instanceof String) {
                return PropertiesMap.stringArray(list);
            }
            if (first instanceof Number) {
                return PropertiesMap.numberArray(list);
            }
            if (first instanceof Boolean) {
                return PropertiesMap.booleanArray(list);
            }
            throw new RuntimeException("Unsupported array type " + first.getClass() + ". Supported array types are arrays of all java primitives (" + "byte[], char[], short[], int[], long[], float[], double[]) " + "and String[]");
        }
        return PropertiesMap.assertSupportedPropertyValue(value);
    }

    public static Object assertSupportedPropertyValue(Object value) {
        if (value == null) {
            throw new RuntimeException("null value not supported");
        }
        Class<?> type = value.getClass();
        if (PropertiesMap.isSupportedType(type) || type.isArray() && PropertiesMap.isSupportedType(type.getComponentType())) {
            return value;
        }
        throw new RuntimeException("Unsupported value type " + type + "." + " Supported value types are all java primitives (byte, char, short, int, " + "long, float, double) and String, as well as arrays of all those types");
    }

    private static boolean isSupportedType(Class<?> type) {
        return type.isPrimitive() || String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type);
    }

    private static Boolean[] booleanArray(List<Boolean> list) {
        return list.toArray(new Boolean[list.size()]);
    }

    private static Number[] numberArray(List<Number> numbers) {
        Number[] internal = new Number[numbers.size()];
        for (int i = 0; i < internal.length; ++i) {
            Number number = numbers.get(i);
            number = number instanceof Float || number instanceof Double ? (Number)number.doubleValue() : (Number)number.longValue();
            internal[i] = number;
        }
        Number[] result = internal[0] instanceof Double ? new Double[internal.length] : new Long[internal.length];
        System.arraycopy(internal, 0, result, 0, internal.length);
        return result;
    }

    private static String[] stringArray(List<String> strings) {
        return strings.toArray(new String[strings.size()]);
    }

    private Object toSerializedType(Object value) {
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                int size = Array.getLength(value);
                ArrayList<Object> result = new ArrayList<Object>();
                for (int i = 0; i < size; ++i) {
                    result.add(Array.get(value, i));
                }
                return result;
            }
            return Arrays.asList((Object[])value);
        }
        return value;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }
}

