/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.batch;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.MediaType;
import org.neo4j.rest.graphdb.converter.RestResultConverter;

public class RestOperations {
    private RestResultConverter resultConverter;
    private AtomicLong currentBatchId = new AtomicLong(0L);
    private Map<Long, RestOperation> operations = new LinkedHashMap<Long, RestOperation>();
    private MediaType contentType;
    private MediaType acceptHeader;

    public RestOperations() {
        this.contentType = MediaType.APPLICATION_JSON_TYPE;
        this.acceptHeader = MediaType.APPLICATION_JSON_TYPE;
    }

    public RestOperations(RestResultConverter converter) {
        this.resultConverter = converter;
    }

    public RestOperation getOperation(Long batchId) {
        return this.operations.get(batchId);
    }

    public Map<Long, RestOperation> getRecordedRequests() {
        return this.operations;
    }

    public RestOperation record(RestOperation.Methods method, String path, Object data, String baseUri) {
        long batchId = this.currentBatchId.incrementAndGet();
        RestOperation r = new RestOperation(batchId, method, path, this.contentType, this.acceptHeader, data, baseUri);
        r.setConverter(this.resultConverter);
        this.operations.put(batchId, r);
        return r;
    }

    public static class RestOperation {
        private Methods method;
        private Object data;
        private final String baseUri;
        private long batchId;
        private String uri;
        private MediaType contentType;
        private MediaType acceptHeader;
        private RestResultConverter resultConverter;

        public void setConverter(RestResultConverter converter) {
            this.resultConverter = converter;
        }

        public RestOperation(long batchId, Methods method, String uri, MediaType contentType, MediaType acceptHeader, Object data, String baseUri) {
            this.batchId = batchId;
            this.method = method;
            this.uri = uri;
            this.contentType = contentType;
            this.acceptHeader = acceptHeader;
            this.data = data;
            this.baseUri = baseUri;
        }

        public RestResultConverter getResultConverter() {
            return this.resultConverter;
        }

        public Methods getMethod() {
            return this.method;
        }

        public Object getData() {
            return this.data;
        }

        public long getBatchId() {
            return this.batchId;
        }

        public String getUri() {
            return this.uri;
        }

        public MediaType getContentType() {
            return this.contentType;
        }

        public MediaType getAcceptHeader() {
            return this.acceptHeader;
        }

        public String getBaseUri() {
            return this.baseUri;
        }

        public boolean isSameUri(String baseUri) {
            return this.baseUri.equals(baseUri);
        }

        public static enum Methods {
            POST,
            PUT,
            GET,
            DELETE;

        }
    }
}

