/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.entity;

import java.net.URI;
import java.util.Map;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestAPIInternal;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestNode;

public class RestRelationship
extends RestEntity
implements Relationship {
    RestRelationship(URI uri, RestAPI restApi) {
        super(uri, restApi);
    }

    public RestRelationship(String uri, RestAPI restApi) {
        super(uri, restApi);
    }

    public RestRelationship(Map<?, ?> data, RestAPI restApi) {
        super(data, restApi);
    }

    public RestRelationship(RestRelationship relationship, RestAPI restApi) {
        super(relationship, restApi);
    }

    @Override
    protected void doUpdate() {
        this.updateFrom(this.restApi.getRelationshipById(this.getId(), RestAPIInternal.Load.ForceFromServer), this.restApi);
    }

    public Node getEndNode() {
        return this.node((String)this.getStructuralData().get("end"));
    }

    public Node[] getNodes() {
        return new Node[]{this.node((String)this.getStructuralData().get("start")), this.node((String)this.getStructuralData().get("end"))};
    }

    public static RestRelationship fromCypher(long id, String type, Map<String, Object> props, long start, long end, RestAPI facade) {
        Map restData = MapUtil.map((Object[])new Object[]{"data", props, "self", RestRelationship.relUri(facade, id), "start", RestNode.nodeUri(facade, start), "end", RestNode.nodeUri(facade, end), "type", type});
        return new RestRelationship(restData, facade);
    }

    public Node getOtherNode(Node node) {
        long nodeId = node.getId();
        String startNodeUri = (String)this.getStructuralData().get("start");
        String endNodeUri = (String)this.getStructuralData().get("end");
        if (RestRelationship.getEntityId(startNodeUri) == nodeId) {
            return this.node(endNodeUri);
        }
        if (RestRelationship.getEntityId(endNodeUri) == nodeId) {
            return this.node(startNodeUri);
        }
        throw new NotFoundException(node + " isn't one of start/end for " + this);
    }

    private RestNode node(String uri) {
        return this.getRestApi().getNodeById(RestRelationship.getEntityId(uri), RestAPIInternal.Load.FromCache);
    }

    public static String relUri(RestAPI facade, long id) {
        return facade.getBaseUri() + "/relationship/" + id;
    }

    public Node getStartNode() {
        return this.node((String)this.getStructuralData().get("start"));
    }

    public RelationshipType getType() {
        return DynamicRelationshipType.withName((String)((String)this.getStructuralData().get("type")));
    }

    public boolean isType(RelationshipType type) {
        return type.name().equals(this.getStructuralData().get("type"));
    }

    public RestRelationship create(RestNode startNode, RestNode endNode, RelationshipType type, Map<String, Object> props) {
        return this.restApi.createRelationship(startNode, endNode, type, props);
    }
}

