/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.util.Map;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.query.RestCypherQueryEngine;
import org.neo4j.rest.graphdb.util.ResultConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;

public class SpringRestCypherQueryEngine
implements CypherQueryEngine {
    public static final Logger log = LoggerFactory.getLogger(SpringRestCypherQueryEngine.class);
    private final RestCypherQueryEngine restCypherQueryEngine;
    private org.springframework.data.neo4j.conversion.ResultConverter resultConverter;

    public SpringRestCypherQueryEngine(RestAPI restAPI, org.springframework.data.neo4j.conversion.ResultConverter resultConverter) {
        this.resultConverter = resultConverter;
        this.restCypherQueryEngine = new RestCypherQueryEngine(restAPI, new SpringResultConverter(resultConverter));
    }

    public Result<Map<String, Object>> query(String statement, Map<String, Object> params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Executing remote cypher query: %s params %s", statement, params));
        }
        return new QueryResultBuilder(this.restCypherQueryEngine.query(statement, params), this.resultConverter);
    }

    public org.springframework.data.neo4j.conversion.ResultConverter getResultConverter() {
        return this.resultConverter;
    }

    public void setResultConverter(org.springframework.data.neo4j.conversion.ResultConverter resultConverter) {
        this.resultConverter = resultConverter;
    }

    private static class SpringResultConverter
    implements ResultConverter {
        private final org.springframework.data.neo4j.conversion.ResultConverter resultConverter;

        public SpringResultConverter(org.springframework.data.neo4j.conversion.ResultConverter resultConverter) {
            this.resultConverter = resultConverter;
        }

        public Object convert(Object value, Class target) {
            return this.resultConverter.convert(value, target);
        }
    }
}

