/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.lucene.search.Query;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.AbstractIndexHits;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestAPIIndex;
import org.neo4j.rest.graphdb.RestAPIIndexImpl;
import org.neo4j.rest.graphdb.RestAPIInternal;
import org.neo4j.rest.graphdb.RestRequest;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.converter.RestIndexHitsConverter;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestEntityCache;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;
import org.neo4j.rest.graphdb.index.IndexInfo;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.index.SimpleIndexHits;
import org.neo4j.rest.graphdb.query.CypherResult;
import org.neo4j.rest.graphdb.query.CypherTransaction;
import org.neo4j.rest.graphdb.query.CypherTransactionExecutionException;
import org.neo4j.rest.graphdb.query.CypherTxResult;
import org.neo4j.rest.graphdb.query.RestCypherTransactionManager;
import org.neo4j.rest.graphdb.transaction.TransactionFinishListener;
import org.neo4j.rest.graphdb.traversal.RestTraversalDescription;
import org.neo4j.rest.graphdb.traversal.RestTraverser;
import org.neo4j.rest.graphdb.util.QueryResult;
import org.neo4j.rest.graphdb.util.QueryResultBuilder;
import org.neo4j.rest.graphdb.util.ResultConverter;
import org.springframework.dao.DataIntegrityViolationException;

public class RestAPICypherImpl
implements RestAPI {
    public static final String _QUERY_RETURN_NODE = " RETURN id(n) as id, labels(n) as labels, n as properties";
    public static final String _QUERY_RETURN_REL = " RETURN id(r) as id, type(r) as type, r as properties, id(startNode(r)) as start, id(endNode(r)) as end";
    public static final String _MATCH_NODE_QUERY = " MATCH (n) WHERE id(n) = {id} ";
    public static final String GET_NODE_QUERY = " MATCH (n) WHERE id(n) = {id}  RETURN id(n) as id, labels(n) as labels, n as properties";
    public static final String _MATCH_REL_QUERY = " START r=rel({id}) ";
    public static final String GET_REL_QUERY = " START r=rel({id})  RETURN id(r) as id, type(r) as type, r as properties, id(startNode(r)) as start, id(endNode(r)) as end";
    public static final String GET_REL_TYPES_QUERY = " MATCH (n) WHERE id(n) = {id}  MATCH (n)-[r]-() RETURN distinct type(r) as relType";
    private RestAPIIndex restAPIIndex;
    private final RestEntityCache entityCache = new RestEntityCache(this);
    private RestEntityExtractor restEntityExtractor = new RestEntityExtractor(this);
    private final RestAPI restAPI;
    private final RestCypherTransactionManager txManager = new RestCypherTransactionManager(this);
    private static final String FULLPATH = "fullpath";

    public static String MATCH_NODE_QUERY(String name) {
        return " MATCH (" + name + ") WHERE id(" + name + ") = {id_" + name + "} ";
    }

    private String createNodeQuery(Collection<String> labels) {
        String labelString = this.toLabelString(labels);
        return "CREATE (n" + labelString + " {props}) " + _QUERY_RETURN_NODE;
    }

    private String mergeQuery(String labelName, String key, Collection<String> labels) {
        StringBuilder setLabels = new StringBuilder();
        if (labels != null) {
            for (String label : labels) {
                if (label.equals(labelName)) continue;
                setLabels.append("SET n:").append(label).append(" ");
            }
        }
        return "MERGE (n:`" + labelName + "` {`" + key + "`: {value}}) ON CREATE SET n={props} " + setLabels + _QUERY_RETURN_NODE;
    }

    private String toLabelString(Collection<String> labels) {
        if (labels == null || labels.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String label : labels) {
            sb.append(":").append(label);
        }
        return sb.toString();
    }

    protected RestAPICypherImpl(RestAPI restAPI) {
        this.restAPI = restAPI;
        this.restAPIIndex = new RestAPIIndexImpl(this);
    }

    @Override
    public RestNode getNodeById(long id, RestAPIInternal.Load force) {
        RestNode restNode;
        if (force != RestAPIInternal.Load.ForceFromServer && (restNode = this.getNodeFromCache(id)) != null) {
            return restNode;
        }
        if (force == RestAPIInternal.Load.FromCache) {
            return new RestNode(RestNode.nodeUri(this, id), (RestAPI)this);
        }
        Iterator<List<Object>> result = this.runQuery(GET_NODE_QUERY, MapUtil.map((Object[])new Object[]{"id", id})).getRows().iterator();
        if (!result.hasNext()) {
            throw new NotFoundException("Node not found " + id);
        }
        List<Object> row = result.next();
        return this.addToCache(this.toNode(row));
    }

    @Override
    public RestNode addToCache(RestNode restNode) {
        return this.entityCache.addToCache(restNode);
    }

    @Override
    public RestRelationship addToCache(RestRelationship rel) {
        return this.entityCache.addToCache(rel);
    }

    @Override
    public RestNode getNodeFromCache(long id) {
        return this.entityCache.getNode(id);
    }

    @Override
    public RestRelationship getRelFromCache(long id) {
        return this.entityCache.getRelationship(id);
    }

    @Override
    public void removeNodeFromCache(long id) {
        this.entityCache.removeNode(id);
    }

    @Override
    public void removeRelFromCache(long id) {
        this.entityCache.removeRelationship(id);
    }

    @Override
    public RestNode getNodeById(long id) {
        return this.getNodeById(id, RestAPIInternal.Load.FromServer);
    }

    @Override
    public RestRelationship getRelationshipById(long id) {
        return this.getRelationshipById(id, RestAPIInternal.Load.FromServer);
    }

    @Override
    public RestRelationship getRelationshipById(long id, RestAPIInternal.Load force) {
        RestRelationship restRel;
        if (force != RestAPIInternal.Load.ForceFromServer && (restRel = this.getRelFromCache(id)) != null) {
            return restRel;
        }
        if (force == RestAPIInternal.Load.FromCache) {
            return new RestRelationship(RestRelationship.relUri(this, id), (RestAPI)this);
        }
        try {
            Iterator<List<Object>> result = this.runQuery(GET_REL_QUERY, MapUtil.map((Object[])new Object[]{"id", id})).getRows().iterator();
            if (!result.hasNext()) {
                throw new NotFoundException("Relationship not found " + id);
            }
            List<Object> row = result.next();
            return this.addToCache(this.toRel(row));
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (CypherTransactionExecutionException ctee) {
            if (ctee.contains("Neo.DatabaseError.Statement.ExecutionFailure", "not found")) {
                throw new NotFoundException("Relationship not found " + id);
            }
            throw ctee;
        }
    }

    private RestNode toNode(List<Object> row) {
        long id = ((Number)row.get(0)).longValue();
        List labels = (List)row.get(1);
        Map props = (Map)row.get(2);
        return RestNode.fromCypher(id, labels, props, this);
    }

    private RestRelationship toRel(List<Object> row) {
        long id = ((Number)row.get(0)).longValue();
        String type = (String)row.get(1);
        Map props = (Map)row.get(2);
        long start = ((Number)row.get(3)).longValue();
        long end = ((Number)row.get(4)).longValue();
        return RestRelationship.fromCypher(id, type, props, start, end, this);
    }

    @Override
    public RestNode createNode(Map<String, Object> props) {
        return this.createNode(props, Collections.emptyList());
    }

    @Override
    public RestNode createNode(Map<String, Object> props, Collection<String> labels) {
        Iterator<List<Object>> result = this.runQuery(this.createNodeQuery(labels), MapUtil.map((Object[])new Object[]{"props", this.props(props)})).getRows().iterator();
        if (result.hasNext()) {
            return this.addToCache(this.toNode(result.next()));
        }
        throw new RuntimeException("Error creating node with labels: " + labels + " and props: " + props + " no data returned");
    }

    @Override
    public RestNode merge(String labelName, String key, Object value, Map<String, Object> nodeProperties, Collection<String> labels) {
        if (labelName == null || key == null || value == null) {
            throw new IllegalArgumentException("Label " + labelName + " key " + key + " and value must not be null");
        }
        Map props = (nodeProperties = this.props(nodeProperties)).containsKey(key) ? nodeProperties : MapUtil.copyAndPut(nodeProperties, (Object)key, (Object)value);
        Map params = MapUtil.map((Object[])new Object[]{"props", props, "value", value});
        Iterator<List<Object>> result = this.runQuery(this.mergeQuery(labelName, key, labels), params).getRows().iterator();
        if (!result.hasNext()) {
            throw new RuntimeException("Error merging node with labels: " + labelName + " key " + key + " value " + value + " labels " + labels + " and props: " + props + " no data returned");
        }
        return this.addToCache(this.toNode(result.next()));
    }

    @Override
    public RestRelationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> props) {
        String statement = RestAPICypherImpl.MATCH_NODE_QUERY("n") + RestAPICypherImpl.MATCH_NODE_QUERY("m") + " CREATE (n)-[r:`" + type.name() + "`]->(m) SET r={props} " + _QUERY_RETURN_REL;
        Map params = MapUtil.map((Object[])new Object[]{"id_n", startNode.getId(), "id_m", endNode.getId(), "props", this.props(props)});
        CypherTransaction.Result result = this.runQuery(statement, params);
        if (!result.hasData()) {
            throw new RuntimeException("Error creating relationship from " + startNode + " to " + endNode + " type " + type.name());
        }
        Iterator<List<Object>> it = result.getRows().iterator();
        return this.toRel(it.next());
    }

    @Override
    public void removeLabel(RestNode node, String label) {
        CypherTransaction.Result result = this.runQuery(_MATCH_NODE_QUERY + " REMOVE n:`" + label + "` " + _QUERY_RETURN_NODE, MapUtil.map((Object[])new Object[]{"id", node.getId()}));
        if (!result.hasData()) {
            throw new RuntimeException("Error removing label " + label + " from node " + node);
        }
    }

    @Override
    public Iterable<RestNode> getNodesByLabel(String label) {
        String statement = "MATCH (n:`" + label + "`) " + _QUERY_RETURN_NODE;
        return this.queryForNodes(statement, null);
    }

    private Iterable<RestNode> queryForNodes(String statement, Map<String, Object> params) {
        Iterable<List<Object>> result = this.runQuery(statement, params).getRows();
        return new IterableWrapper<RestNode, List<Object>>(result){

            protected RestNode underlyingObjectToObject(List<Object> row) {
                return RestAPICypherImpl.this.addToCache(RestAPICypherImpl.this.toNode(row));
            }
        };
    }

    @Override
    public Iterable<RestNode> getNodesByLabelAndProperty(String label, String property, Object value) {
        String statement = "MATCH (n:`" + label + "`) WHERE n.`" + property + "` = {value} " + _QUERY_RETURN_NODE;
        return this.queryForNodes(statement, MapUtil.map((Object[])new Object[]{"value", value}));
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes(RestNode node) {
        Iterable<List<Object>> result = this.runQuery(GET_REL_TYPES_QUERY, MapUtil.map((Object[])new Object[]{"id", node.getId()})).getRows();
        return new IterableWrapper<RelationshipType, List<Object>>(result){

            protected RelationshipType underlyingObjectToObject(List<Object> row) {
                return DynamicRelationshipType.withName((String)row.get(0).toString());
            }
        };
    }

    @Override
    public int getDegree(RestNode restNode, RelationshipType type, Direction direction) {
        String nodeDegreeQuery = "MATCH (n)" + this.relPattern(direction, type) + "() WHERE id(n) = {id} RETURN count(*) as degree";
        Iterator<List<Object>> degree = this.runQuery(nodeDegreeQuery, MapUtil.map((Object[])new Object[]{"id", restNode.getId()})).getRows().iterator();
        if (!degree.hasNext()) {
            return 0;
        }
        return ((Number)degree.next().get(0)).intValue();
    }

    private String relPattern(Direction direction, RelationshipType ... types) {
        String typeString = this.toTypeString(types);
        String relPattern = "-[r]-";
        if (!typeString.isEmpty()) {
            relPattern = "-[r " + typeString + "]-";
        }
        if (direction == Direction.OUTGOING) {
            relPattern = relPattern + ">";
        } else if (direction == Direction.INCOMING) {
            relPattern = "<" + relPattern;
        }
        return relPattern;
    }

    private String toTypeString(RelationshipType ... types) {
        if (types == null || types.length == 0) {
            return "";
        }
        StringBuilder typeString = new StringBuilder();
        for (RelationshipType type : types) {
            if (type == null) continue;
            if (typeString.length() > 0) {
                typeString.append("|");
            }
            typeString.append(':').append('`').append(type.name()).append("`");
        }
        return typeString.toString();
    }

    @Override
    public Iterable<Relationship> getRelationships(RestNode restNode, Direction direction, RelationshipType ... types) {
        String statement = " MATCH (n) WHERE id(n) = {id}  MATCH (n)" + this.relPattern(direction, types) + "() " + _QUERY_RETURN_REL;
        CypherTransaction.Result result = this.runQuery(statement, MapUtil.map((Object[])new Object[]{"id", restNode.getId()}));
        return new IterableWrapper<Relationship, List<Object>>(result.getRows()){

            protected Relationship underlyingObjectToObject(List<Object> row) {
                return RestAPICypherImpl.this.toRel(row);
            }
        };
    }

    @Override
    public void addLabels(RestNode node, Collection<String> labels) {
        String statement = " MATCH (n) WHERE id(n) = {id}  SET n" + this.toLabelString(labels) + _QUERY_RETURN_NODE;
        CypherTransaction.Result result = this.runQuery(statement, MapUtil.map((Object[])new Object[]{"id", node.getId()}));
        if (!result.hasData()) {
            throw new RuntimeException("Error adding labels " + labels + " to node " + node);
        }
    }

    @Override
    public RestRequest getRestRequest() {
        return this.restAPI.getRestRequest();
    }

    @Override
    public Transaction beginTx() {
        return this.txManager.beginTx();
    }

    public RestCypherTransactionManager getTxManager() {
        return this.txManager;
    }

    public <S extends PropertyContainer> IndexHits<S> getIndexQuery(Class<S> entityType, String indexName, String key, Object value) {
        String indexPath = RestAPIIndexImpl.indexPath(entityType, indexName, key, value);
        RequestResult response = this.getRestRequest().get(indexPath);
        if (response.statusIs((Response.StatusType)Response.Status.OK)) {
            return new RestIndexHitsConverter<S>(this, entityType).convertFromRepresentation(response);
        }
        return new SimpleIndexHits<S>(Collections.emptyList(), 0, entityType, this);
    }

    public <S extends PropertyContainer> IndexHits<S> queryIndexQuery(Class<S> entityType, String indexName, String key, Object value) {
        String indexPath = RestAPIIndexImpl.queryPath(entityType, indexName, key, value);
        RequestResult response = this.getRestRequest().get(indexPath);
        if (response.statusIs((Response.StatusType)Response.Status.OK)) {
            return new RestIndexHitsConverter<S>(this, entityType).convertFromRepresentation(response);
        }
        return new SimpleIndexHits<S>(Collections.emptyList(), 0, entityType, this);
    }

    @Override
    public <S extends PropertyContainer> IndexHits<S> getIndex(Class<S> entityType, String indexName, String key, Object value) {
        String index;
        if (value instanceof Query) {
            return this.getIndexQuery(entityType, indexName, key, value);
        }
        String string = index = key == null ? ":`" + indexName + "`({query})" : ":`" + indexName + "`(`" + key + "`={query})";
        if (Node.class.isAssignableFrom(entityType)) {
            String statement = "start n=node" + index + _QUERY_RETURN_NODE;
            CypherTransaction.Result result = this.runQuery(statement, MapUtil.map((Object[])new Object[]{"query", value}));
            return this.toIndexHits(result, true);
        }
        if (Relationship.class.isAssignableFrom(entityType)) {
            String statement = "start r=rel" + index + _QUERY_RETURN_REL;
            CypherTransaction.Result result = this.runQuery(statement, MapUtil.map((Object[])new Object[]{"query", value}));
            return this.toIndexHits(result, false);
        }
        throw new IllegalStateException("Unknown index entity type " + entityType);
    }

    @Override
    public <S extends PropertyContainer> IndexHits<S> queryIndex(Class<S> entityType, String indexName, String key, Object value) {
        if (value instanceof Query) {
            return this.queryIndexQuery(entityType, indexName, key, value);
        }
        String index = ":`" + indexName + "`({query})";
        if (key != null && !key.isEmpty() && !value.toString().contains(":")) {
            value = key + ":" + value;
        }
        if (Node.class.isAssignableFrom(entityType)) {
            String statement = "start n=node" + index + _QUERY_RETURN_NODE;
            CypherTransaction.Result result = this.runQuery(statement, MapUtil.map((Object[])new Object[]{"query", value}));
            return this.toIndexHits(result, true);
        }
        if (Relationship.class.isAssignableFrom(entityType)) {
            String statement = "start r=rel" + index + _QUERY_RETURN_REL;
            CypherTransaction.Result result = this.runQuery(statement, MapUtil.map((Object[])new Object[]{"query", value}));
            return this.toIndexHits(result, false);
        }
        throw new IllegalStateException("Unknown index entity type " + entityType);
    }

    private <S extends PropertyContainer> IndexHits<S> toIndexHits(CypherTransaction.Result result, final boolean isNode) {
        final int size = IteratorUtil.count(result.getRows());
        final Iterator<List<Object>> it = result.getRows().iterator();
        return new AbstractIndexHits<S>(){

            public int size() {
                return size;
            }

            public float currentScore() {
                return 0.0f;
            }

            protected S fetchNextOrNull() {
                if (!it.hasNext()) {
                    return null;
                }
                return isNode ? RestAPICypherImpl.this.addToCache(RestAPICypherImpl.this.toNode((List)it.next())) : RestAPICypherImpl.this.toRel((List)it.next());
            }
        };
    }

    @Override
    public RestIndexManager index() {
        return this.restAPIIndex.index();
    }

    @Override
    public void deleteEntity(RestEntity entity) {
        if (entity instanceof Node) {
            this.runQuery(" MATCH (n) WHERE id(n) = {id}  DELETE n", MapUtil.map((Object[])new Object[]{"id", entity.getId()}));
            this.removeNodeFromCache(entity.getId());
        } else if (entity instanceof Relationship) {
            this.runQuery(" START r=rel({id})  DELETE r", MapUtil.map((Object[])new Object[]{"id", entity.getId()}));
            this.removeRelFromCache(entity.getId());
        }
    }

    @Override
    public void setPropertyOnEntity(RestEntity entity, String key, Object value) {
        if (entity instanceof Node) {
            this.runQuery(" MATCH (n) WHERE id(n) = {id}  SET n.`" + key + "` = {value} ", MapUtil.map((Object[])new Object[]{"id", entity.getId(), "value", value}));
        } else if (entity instanceof Relationship) {
            this.runQuery(" START r=rel({id})  SET r.`" + key + "` = {value} ", MapUtil.map((Object[])new Object[]{"id", entity.getId(), "value", value}));
        }
    }

    @Override
    public void setPropertiesOnEntity(RestEntity entity, Map<String, Object> properties) {
        if (entity instanceof Node) {
            this.runQuery(" MATCH (n) WHERE id(n) = {id}  SET n = {props} ", MapUtil.map((Object[])new Object[]{"id", entity.getId(), "props", properties}));
        } else if (entity instanceof Relationship) {
            this.runQuery(" START r=rel({id})  SET r = {props} ", MapUtil.map((Object[])new Object[]{"id", entity.getId(), "props", properties}));
        }
    }

    @Override
    public void removeProperty(RestEntity entity, String key) {
        if (entity instanceof Node) {
            this.runQuery(" MATCH (n) WHERE id(n) = {id}  REMOVE n.`" + key + "`", MapUtil.map((Object[])new Object[]{"id", entity.getId()}));
        } else if (entity instanceof Relationship) {
            this.runQuery(" START r=rel({id})  REMOVE r.`" + key + "`", MapUtil.map((Object[])new Object[]{"id", entity.getId()}));
        }
    }

    @Override
    public RestNode getOrCreateNode(RestIndex<Node> index, String key, Object value, Map<String, Object> properties, Collection<String> labels) {
        return this.restAPIIndex.getOrCreateNode(index, key, value, properties, labels);
    }

    @Override
    public RestRelationship getOrCreateRelationship(RestIndex<Relationship> index, String key, Object value, RestNode start, RestNode end, String type, Map<String, Object> properties) {
        return this.restAPIIndex.getOrCreateRelationship(index, key, value, start, end, type, properties);
    }

    @Override
    public CypherResult query(String statement, Map<String, Object> params) {
        return new CypherTxResult(this.runQuery(statement, params, true));
    }

    private List<CypherTransaction.Result> runQueries(Collection<CypherTransaction.Statement> statements) {
        if (!this.txManager.isActive()) {
            CypherTransaction tx = this.newCypherTransaction();
            tx.addAll(statements);
            return tx.commit();
        }
        CypherTransaction tx = this.txManager.getCypherTransaction();
        tx.addAll(statements);
        return tx.send();
    }

    private CypherTransaction.Result runQuery(String statement, Map<String, Object> params, boolean replace) {
        if (!this.txManager.isActive()) {
            return this.newCypherTransaction().commit(statement, params, replace);
        }
        return this.txManager.getCypherTransaction().send(statement, params, replace);
    }

    private CypherTransaction.Result runQuery(String statement, Map<String, Object> params) {
        return this.runQuery(statement, params, false);
    }

    public CypherTransaction newCypherTransaction() {
        return new CypherTransaction(this, CypherTransaction.ResultType.row);
    }

    @Override
    public QueryResult<Map<String, Object>> query(String statement, Map<String, Object> params, ResultConverter resultConverter) {
        CypherTransaction.Result result = this.runQuery(statement, params, true);
        IterableWrapper<Map<String, Object>, Map<String, Object>> it = new IterableWrapper<Map<String, Object>, Map<String, Object>>((Iterable)result){

            protected Map<String, Object> underlyingObjectToObject(Map<String, Object> value) {
                return RestAPICypherImpl.this.convertRestEntitiesInRow(value);
            }
        };
        return new QueryResultBuilder<Map<String, Object>>((Iterable<Map<String, Object>>)it, resultConverter);
    }

    private Map<String, Object> convertRestEntitiesInRow(Map<String, Object> value) {
        Map<String, Object> map = value;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            RestEntity v;
            Map mapValue;
            Object original = entry.getValue();
            if (!(original instanceof Map) || !(mapValue = (Map)original).containsKey("id") || !mapValue.containsKey("properties") || (v = this.createRestEntity(mapValue)) == null) continue;
            entry.setValue(v);
        }
        return map;
    }

    @Override
    public RestTraverser traverse(RestNode restNode, Map<String, Object> description) {
        RequestResult result = this.getRestRequest().with(restNode.getUri()).post("traverse/fullpath", description);
        if (result.statusOtherThan((Response.StatusType)Response.Status.OK)) {
            throw new RuntimeException(String.format("Error executing traversal: %d %s", result.getStatus(), description));
        }
        Object col = result.toEntity();
        if (!(col instanceof Collection)) {
            throw new RuntimeException(String.format("Unexpected traversal result, %s instead of collection", col != null ? col.getClass() : null));
        }
        return new RestTraverser((Collection)col, restNode.getRestApi());
    }

    @Override
    public RequestResult batch(Collection<Map<String, Object>> batchRequestData) {
        return this.restAPI.batch(batchRequestData);
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> getIndex(String indexName) {
        RestIndexManager index = this.index();
        if (index.existsForNodes(indexName)) {
            return index.forNodes(indexName);
        }
        if (index.existsForRelationships(indexName)) {
            return (RestIndex)index.forRelationships(indexName);
        }
        throw new IllegalArgumentException("Index " + indexName + " does not yet exist");
    }

    @Override
    public void createIndex(String type, String indexName, Map<String, String> config) {
        this.restAPIIndex.createIndex(type, indexName, config);
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> createIndex(Class<T> type, String indexName, Map<String, String> config) {
        return this.restAPIIndex.createIndex(type, indexName, config);
    }

    @Override
    public void close() {
        this.restAPI.close();
    }

    @Override
    public Relationship getOrCreateRelationship(Node start, Node end, RelationshipType type, Direction direction, Map<String, Object> props) {
        String relPattern = this.relPattern(direction, type);
        String statement = RestAPICypherImpl.MATCH_NODE_QUERY("n") + RestAPICypherImpl.MATCH_NODE_QUERY("m") + " MERGE (n)" + relPattern + "(m) ON CREATE SET r={props}" + _QUERY_RETURN_REL;
        CypherTransaction.Result result = this.runQuery(statement, MapUtil.map((Object[])new Object[]{"id_n", start.getId(), "id_m", end.getId(), "props", this.props(props)}));
        if (!result.hasData()) {
            throw new RuntimeException("Error creating relationship from " + start + " to " + end + " type " + type.name() + " direction " + direction);
        }
        return this.toRel(result.getRows().iterator().next());
    }

    @Override
    public Iterable<Relationship> updateRelationships(Node start, Collection<Node> endNodes, RelationshipType type, Direction direction, String targetLabel) {
        String targetLabelPredicate = targetLabel == null ? "" : " AND (m:`" + targetLabel + "` OR m:`_" + targetLabel + "`)";
        String relPattern = this.relPattern(direction, type);
        String statement1 = "MATCH (n)" + relPattern + "(m) WHERE id(n) = {id_n} " + targetLabelPredicate + " AND NOT id(m) IN {ids_m} DELETE r RETURN id(r) as id_r";
        String statement2 = RestAPICypherImpl.MATCH_NODE_QUERY("n") + " MATCH (m) WHERE id(m) IN {ids_m} MERGE (n)" + relPattern + "(m)" + _QUERY_RETURN_REL;
        Map params = MapUtil.map((Object[])new Object[]{"id_n", start.getId(), "ids_m", this.nodeIds(endNodes)});
        List<CypherTransaction.Result> results = this.runQueries(Arrays.asList(new CypherTransaction.Statement(statement1, params, CypherTransaction.ResultType.row, false), new CypherTransaction.Statement(statement2, params, CypherTransaction.ResultType.row, false)));
        Iterable<List<Object>> mergeResults = results.get(1).getRows();
        return new IterableWrapper<Relationship, List<Object>>(mergeResults){

            protected Relationship underlyingObjectToObject(List<Object> row) {
                return RestAPICypherImpl.this.toRel(row);
            }
        };
    }

    private long[] nodeIds(Collection<Node> nodes) {
        long[] ids = new long[nodes.size()];
        int i = 0;
        for (Node node : nodes) {
            ids[i++] = node.getId();
        }
        return ids;
    }

    public Map<String, Object> props(Map<String, Object> props) {
        return props == null ? Collections.emptyMap() : props;
    }

    @Override
    public boolean isAutoIndexingEnabled(Class<? extends PropertyContainer> clazz) {
        return this.restAPIIndex.isAutoIndexingEnabled(clazz);
    }

    @Override
    public void setAutoIndexingEnabled(Class<? extends PropertyContainer> clazz, boolean enabled) {
        this.restAPIIndex.setAutoIndexingEnabled(clazz, enabled);
    }

    @Override
    public Set<String> getAutoIndexedProperties(Class forClass) {
        return this.restAPIIndex.getAutoIndexedProperties(forClass);
    }

    @Override
    public void startAutoIndexingProperty(Class forClass, String s) {
        this.restAPIIndex.startAutoIndexingProperty(forClass, s);
    }

    @Override
    public void stopAutoIndexingProperty(Class forClass, String s) {
        this.restAPIIndex.stopAutoIndexingProperty(forClass, s);
    }

    @Override
    public void delete(RestIndex index) {
        this.restAPIIndex.delete(index);
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key, Object value) {
        this.restAPIIndex.removeFromIndex(index, entity, key, value);
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key) {
        this.restAPIIndex.removeFromIndex(index, entity, key);
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity) {
        this.restAPIIndex.removeFromIndex(index, entity);
    }

    @Override
    public <T extends PropertyContainer> void addToIndex(final T entity, final RestIndex index, final String key, final Object value) {
        if (!this.getTxManager().isActive()) {
            this.restAPIIndex.addToIndex(entity, index, key, value);
            return;
        }
        this.getTxManager().getRemoteCypherTransaction().registerListener(new TransactionFinishListener(){

            @Override
            public void comitted() {
                RestAPICypherImpl.this.restAPIIndex.addToIndex(entity, index, key, value);
            }

            @Override
            public void rolledBack() {
            }
        });
    }

    @Override
    public <T extends PropertyContainer> T putIfAbsent(final T entity, final RestIndex index, final String key, final Object value) {
        if (!this.getTxManager().isActive()) {
            return this.restAPIIndex.putIfAbsent(entity, index, key, value);
        }
        this.getTxManager().getRemoteCypherTransaction().registerListener(new TransactionFinishListener(){

            @Override
            public void comitted() {
                PropertyContainer result = RestAPICypherImpl.this.restAPIIndex.putIfAbsent(entity, index, key, value);
                if (result == null || result.equals(entity)) {
                    return;
                }
                throw new DataIntegrityViolationException("Unique property " + key + " was to be set to duplicate value " + value);
            }

            @Override
            public void rolledBack() {
            }
        });
        return entity;
    }

    @Override
    public IndexInfo indexInfo(String indexType) {
        return this.restAPIIndex.indexInfo(indexType);
    }

    @Override
    public boolean hasToUpdate(long lastUpdate) {
        return this.restAPI.hasToUpdate(lastUpdate);
    }

    @Override
    public Collection<String> getAllLabelNames() {
        return this.restAPI.getAllLabelNames();
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.restAPI.getRelationshipTypes();
    }

    @Override
    public RestTraversalDescription createTraversalDescription() {
        return this.restAPI.createTraversalDescription();
    }

    @Override
    public String getBaseUri() {
        return this.restAPI.getBaseUri();
    }

    @Override
    public RestEntityExtractor getEntityExtractor() {
        return this.restEntityExtractor;
    }

    @Override
    public RestEntity createRestEntity(Map data) {
        String uri;
        if (data.containsKey("id") && data.containsKey("properties")) {
            long id = this.asLong(data, "id");
            Map props = (Map)data.get("properties");
            if (data.containsKey("type")) {
                return RestRelationship.fromCypher(id, (String)data.get("type"), props, this.asLong(data, "startNode"), this.asLong(data, "endNode"), this);
            }
            if (data.containsKey("labels")) {
                List labels = (List)data.get("labels");
                return this.entityCache.addToCache(RestNode.fromCypher(id, labels, props, this));
            }
        }
        if ((uri = (String)data.get("self")) == null || uri.isEmpty()) {
            return null;
        }
        if (uri.contains("/node/")) {
            return this.entityCache.addToCache(new RestNode(data, (RestAPI)this));
        }
        if (uri.contains("/relationship/")) {
            return new RestRelationship(data, (RestAPI)this);
        }
        return null;
    }

    protected long asLong(Map data, String idKey) {
        Object idValue = data.get(idKey);
        return idValue instanceof Number ? ((Number)idValue).longValue() : Long.parseLong(idValue.toString());
    }

    public Iterable<Node> getAllNodes() {
        String statement = "MATCH (n)  RETURN id(n) as id, labels(n) as labels, n as properties";
        Iterable<List<Object>> result = this.runQuery(statement, null).getRows();
        return new IterableWrapper<Node, List<Object>>(result){

            protected Node underlyingObjectToObject(List<Object> row) {
                return RestAPICypherImpl.this.addToCache(RestAPICypherImpl.this.toNode(row));
            }
        };
    }

    class RestEntityConverter
    implements ResultConverter {
        ResultConverter delegate;

        public RestEntityConverter(ResultConverter delegate) {
            this.delegate = delegate;
        }

        public Object convert(Object value, Class type) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Object v = this.doConvert(entry.getValue(), type);
                if (v == null) continue;
                entry.setValue(v);
            }
            return map;
        }

        protected Object doConvert(Object value, Class type) {
            if (PropertyContainer.class.isAssignableFrom(type) && value instanceof Map) {
                return RestAPICypherImpl.this.createRestEntity((Map)value);
            }
            return this.delegate.convert(value, type);
        }
    }
}

