/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public class TypeInformation {
    Class type;
    Class[] genericArguments;

    public TypeInformation(Type type) {
        this.type = this.convertToClass(type);
        this.genericArguments = this.extractGenericArguments(type);
    }

    public TypeInformation(Object object) {
        this.type = object.getClass();
        this.genericArguments = this.extractGenericArgumentsFromObject(object);
    }

    private Class convertToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        return (Class)((ParameterizedType)type).getRawType();
    }

    public boolean isSingleType() {
        return !this.isCollectionType();
    }

    public boolean isCollectionType() {
        return this.isCollection() || this.isMap();
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.type);
    }

    public boolean isCollection() {
        return Iterable.class.isAssignableFrom(this.type);
    }

    private Class[] extractGenericArgumentsFromObject(Object object) {
        if (this.isCollectionType()) {
            if (this.isCollection()) {
                if (((Iterable)object).iterator().hasNext()) {
                    return new Class[]{((Iterable)object).iterator().next().getClass()};
                }
            } else if (!((Map)object).isEmpty()) {
                return new Class[]{((Map)object).keySet().iterator().next().getClass(), ((Map)object).values().iterator().next().getClass()};
            }
        }
        return null;
    }

    private Class[] extractGenericArguments(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Class[] result = new Class[actualTypeArguments.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            result[i] = this.convertToClass(actualTypeArguments[i]);
        }
        return result;
    }

    public boolean isInstance(Object resultObject, Class type) {
        return type.isInstance(resultObject);
    }

    public boolean isGraphEntity(Class classType) {
        return Node.class.isAssignableFrom(classType) || Relationship.class.isAssignableFrom(classType);
    }

    public boolean isPath(Class classType) {
        return Path.class.isAssignableFrom(classType);
    }

    public Class getType() {
        return this.type;
    }

    public Class[] getGenericArguments() {
        return this.genericArguments;
    }
}

