/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.index.lucene.ValueContext;
import org.springframework.data.neo4j.fieldaccess.PropertyConverter;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.StartClause;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameter;

abstract class IndexBasedStartClause
extends StartClause {
    public IndexBasedStartClause(PartInfo partInfo) {
        super(partInfo);
    }

    protected Map<PartInfo, Object> matchToPartsAndConvert(Map<Parameter, PartInfo> myParameters, Map<Parameter, Object> parameters, Neo4jTemplate template) {
        LinkedHashMap<PartInfo, Object> result = new LinkedHashMap<PartInfo, Object>();
        for (Map.Entry<Parameter, PartInfo> entry : myParameters.entrySet()) {
            Object value = parameters.get(entry.getKey());
            PartInfo partInfo = entry.getValue();
            Neo4jPersistentProperty property = partInfo.getLeafProperty();
            result.put(partInfo, this.convertIfNecessary(template, value, property));
        }
        return result;
    }

    protected Object convertIfNecessary(Neo4jTemplate template, Object value, Neo4jPersistentProperty property) {
        if (property.isIndexedNumerically()) {
            return new ValueContext(value).indexNumeric();
        }
        if (property.isNeo4jPropertyType() && property.isNeo4jPropertyValue(value)) {
            return value;
        }
        PropertyConverter converter = new PropertyConverter(template.getConversionService(), property);
        return converter.serializePropertyValue(value);
    }

    protected Map<Parameter, PartInfo> findMyParameters(Set<Parameter> parameters) {
        LinkedHashMap<Parameter, PartInfo> result = new LinkedHashMap<Parameter, PartInfo>();
        for (Parameter parameter : parameters) {
            PartInfo partInfo = (PartInfo)this.partInfos.get(parameter.getIndex());
            if (partInfo == null) continue;
            result.put(parameter, partInfo);
        }
        return result;
    }
}

