/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import java.util.Map;
import java.util.WeakHashMap;
import org.neo4j.graphdb.NotFoundException;

class EntityTypeCache {
    private final Map<String, Class<?>> cache = new WeakHashMap();

    EntityTypeCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <Object> Class<Object> getClassForName(String className) {
        try {
            Class<?> result = this.cache.get(className);
            if (result != null) {
                return result;
            }
            Map<String, Class<?>> map = this.cache;
            synchronized (map) {
                result = this.cache.get(className);
                if (result != null) {
                    return result;
                }
                result = Class.forName(className);
                this.cache.put(className, result);
                return result;
            }
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

