/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.neo4j.driver.Record;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class PreparedQuery<T> {
    private final Class<T> resultType;
    private final String cypherQuery;
    private final Map<String, Object> parameters;
    @Nullable
    private final BiFunction<TypeSystem, Record, T> mappingFunction;

    public static <CT> RequiredBuildStep<CT> queryFor(Class<CT> resultType) {
        return new RequiredBuildStep(resultType);
    }

    private PreparedQuery(OptionalBuildSteps<T> optionalBuildSteps) {
        this.resultType = optionalBuildSteps.resultType;
        this.mappingFunction = optionalBuildSteps.mappingFunction;
        this.cypherQuery = optionalBuildSteps.cypherQuery;
        this.parameters = optionalBuildSteps.parameters;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public Optional<BiFunction<TypeSystem, Record, T>> getOptionalMappingFunction() {
        return Optional.ofNullable(this.mappingFunction);
    }

    public String getCypherQuery() {
        return this.cypherQuery;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public static class OptionalBuildSteps<CT> {
        final Class<CT> resultType;
        final String cypherQuery;
        Map<String, Object> parameters = Collections.emptyMap();
        @Nullable
        BiFunction<TypeSystem, Record, ?> mappingFunction;

        OptionalBuildSteps(Class<CT> resultType, String cypherQuery) {
            this.resultType = resultType;
            this.cypherQuery = cypherQuery;
        }

        public OptionalBuildSteps<CT> withParameters(Map<String, Object> newParameters) {
            this.parameters = new HashMap<String, Object>(newParameters);
            return this;
        }

        public OptionalBuildSteps<CT> usingMappingFunction(@Nullable BiFunction<TypeSystem, Record, ?> newMappingFunction) {
            this.mappingFunction = newMappingFunction;
            return this;
        }

        public PreparedQuery<CT> build() {
            return new PreparedQuery(this);
        }
    }

    public static class RequiredBuildStep<CT> {
        private final Class<CT> resultType;

        private RequiredBuildStep(Class<CT> resultType) {
            this.resultType = resultType;
        }

        public OptionalBuildSteps<CT> withCypherQuery(String cypherQuery) {
            return new OptionalBuildSteps<CT>(this.resultType, cypherQuery);
        }
    }
}

