/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.DynamicLabels;
import org.springframework.data.neo4j.core.GenericQueryAndParameters;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.CreateRelationshipStatementHolder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipContext;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipProcessingStateMachine;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.mapping.callback.EventSupport;
import org.springframework.data.neo4j.repository.NoResultException;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@API(status=API.Status.STABLE, since="6.0")
public final class Neo4jTemplate
implements Neo4jOperations,
BeanFactoryAware {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(Neo4jTemplate.class));
    private static final String OPTIMISTIC_LOCKING_ERROR_MESSAGE = "An entity with the required version does not exist.";
    private static final Renderer renderer = Renderer.getDefaultRenderer();
    private final Neo4jClient neo4jClient;
    private final Neo4jMappingContext neo4jMappingContext;
    private final CypherGenerator cypherGenerator;
    private EventSupport eventSupport;
    private final DatabaseSelectionProvider databaseSelectionProvider;

    public Neo4jTemplate(Neo4jClient neo4jClient) {
        this(neo4jClient, new Neo4jMappingContext(), DatabaseSelectionProvider.getDefaultSelectionProvider());
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, DatabaseSelectionProvider databaseSelectionProvider) {
        this(neo4jClient, neo4jMappingContext, databaseSelectionProvider, EntityCallbacks.create());
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, DatabaseSelectionProvider databaseSelectionProvider, EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)neo4jClient, (String)"The Neo4jClient is required");
        Assert.notNull((Object)neo4jMappingContext, (String)"The Neo4jMappingContext is required");
        Assert.notNull((Object)databaseSelectionProvider, (String)"The database name provider is required");
        this.neo4jClient = neo4jClient;
        this.neo4jMappingContext = neo4jMappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
        this.eventSupport = EventSupport.useExistingCallbacks(neo4jMappingContext, entityCallbacks);
        this.databaseSelectionProvider = databaseSelectionProvider;
    }

    @Override
    public long count(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.count(statement);
    }

    @Override
    public long count(Statement statement) {
        return this.count(statement, Collections.emptyMap());
    }

    @Override
    public long count(Statement statement, Map<String, Object> parameters) {
        return this.count(renderer.render(statement), parameters);
    }

    @Override
    public long count(String cypherQuery) {
        return this.count(cypherQuery, Collections.emptyMap());
    }

    @Override
    public long count(String cypherQuery, Map<String, Object> parameters) {
        PreparedQuery<Long> preparedQuery = PreparedQuery.queryFor(Long.class).withCypherQuery(cypherQuery).withParameters(parameters).build();
        return this.toExecutableQuery(preparedQuery).getRequiredSingleResult();
    }

    @Override
    public <T> List<T> findAll(Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, QueryFragmentsAndParameters.forFindAll(entityMetaData)).getResults();
    }

    @Override
    public <T> List<T> findAll(Statement statement, Class<T> domainType) {
        return this.createExecutableQuery(domainType, renderer.render(statement)).getResults();
    }

    @Override
    public <T> List<T> findAll(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement, parameters).getResults();
    }

    @Override
    public <T> Optional<T> findOne(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement, parameters).getSingleResult();
    }

    @Override
    public <T> List<T> findAll(String cypherQuery, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery).getResults();
    }

    @Override
    public <T> List<T> findAll(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery, parameters).getResults();
    }

    @Override
    public <T> Optional<T> findOne(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery, parameters).getSingleResult();
    }

    @Override
    public <T> Optional<T> findById(Object id, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, QueryFragmentsAndParameters.forFindById(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id))).getSingleResult();
    }

    @Override
    public <T> List<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, QueryFragmentsAndParameters.forFindByAllId(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids))).getResults();
    }

    private Object convertIdValues(@Nullable Neo4jPersistentProperty idProperty, Object idValues) {
        return this.neo4jMappingContext.getConversionService().writeValue(idValues, (TypeInformation<?>)ClassTypeInformation.from(idValues.getClass()), idProperty == null ? null : idProperty.getOptionalWritingConverter());
    }

    @Override
    public <T> T save(T instance) {
        return this.saveImpl(instance, this.getDatabaseName());
    }

    private <T> T saveImpl(T instance, @Nullable String inDatabase) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(instance.getClass());
        boolean isEntityNew = entityMetaData.isNew(instance);
        Object entityToBeSaved = this.eventSupport.maybeCallBeforeBind(instance);
        DynamicLabels dynamicLabels = this.determineDynamicLabels(entityToBeSaved, entityMetaData, inDatabase);
        Optional optionalInternalId = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOf(entityMetaData, dynamicLabels))).in(inDatabase).bind(entityToBeSaved).with(this.neo4jMappingContext.getRequiredBinderFunctionFor(entityToBeSaved.getClass()))).fetchAs(Long.class).one();
        if (entityMetaData.hasVersionProperty() && !optionalInternalId.isPresent()) {
            throw new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE);
        }
        PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
        if (entityMetaData.isUsingInternalIds()) {
            propertyAccessor.setProperty(entityMetaData.getRequiredIdProperty(), optionalInternalId.get());
            entityToBeSaved = propertyAccessor.getBean();
        }
        return this.processRelations(entityMetaData, entityToBeSaved, isEntityNew, inDatabase, instance);
    }

    private <T> DynamicLabels determineDynamicLabels(T entityToBeSaved, Neo4jPersistentEntity<?> entityMetaData, @Nullable String inDatabase) {
        return entityMetaData.getDynamicLabelsProperty().map(p -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
            Neo4jClient.RunnableSpecTightToDatabase runnableQuery = (Neo4jClient.RunnableSpecTightToDatabase)((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.createStatementReturningDynamicLabels(entityMetaData))).in(inDatabase).bind(propertyAccessor.getProperty(entityMetaData.getRequiredIdProperty())).to("__id__")).bind(entityMetaData.getStaticLabels()).to("__staticLabels__");
            if (entityMetaData.hasVersionProperty()) {
                runnableQuery = (Neo4jClient.RunnableSpecTightToDatabase)runnableQuery.bind((Long)propertyAccessor.getProperty(entityMetaData.getRequiredVersionProperty()) - 1L).to("__version__");
            }
            Optional<Map<String, Object>> optionalResult = runnableQuery.fetch().one();
            return new DynamicLabels(optionalResult.map(r -> (Collection)r.get("__nodeLabels__")).orElseGet(Collections::emptyList), (Collection)propertyAccessor.getProperty((PersistentProperty)p));
        }).orElse(DynamicLabels.EMPTY);
    }

    @Override
    public <T> List<T> saveAll(Iterable<T> instances) {
        ArrayList entities;
        String databaseName = this.getDatabaseName();
        if (instances instanceof Collection) {
            entities = new ArrayList((Collection)instances);
        } else {
            entities = new ArrayList();
            instances.forEach(entities::add);
        }
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        Class domainClass = CollectionUtils.findCommonElementType(entities);
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainClass);
        if (entityMetaData.isUsingInternalIds() || entityMetaData.hasVersionProperty() || entityMetaData.getDynamicLabelsProperty().isPresent()) {
            log.debug((CharSequence)"Saving entities using single statements.");
            return entities.stream().map(e -> this.saveImpl(e, databaseName)).collect(Collectors.toList());
        }
        List isNewIndicator = entities.stream().map(entity -> ((Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(entity.getClass())).isNew(entity)).collect(Collectors.toList());
        List<Object> entitiesToBeSaved = entities.stream().map(this.eventSupport::maybeCallBeforeBind).collect(Collectors.toList());
        Function binderFunction = this.neo4jMappingContext.getRequiredBinderFunctionFor(domainClass);
        List entityList = entitiesToBeSaved.stream().map(binderFunction).collect(Collectors.toList());
        ResultSummary resultSummary = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOfMultipleInstancesOf(entityMetaData))).in(databaseName).bind(entityList).to("__entities__")).run();
        entitiesToBeSaved.forEach(entityToBeSaved -> {
            int positionInList = entitiesToBeSaved.indexOf(entityToBeSaved);
            this.processRelations(entityMetaData, entityToBeSaved, (Boolean)isNewIndicator.get(positionInList), databaseName, entities.get(positionInList));
        });
        SummaryCounters counters = resultSummary.counters();
        log.debug(() -> String.format("Created %d and deleted %d nodes, created %d and deleted %d relationships and set %d properties.", counters.nodesCreated(), counters.nodesDeleted(), counters.relationshipsCreated(), counters.relationshipsDeleted(), counters.propertiesSet()));
        return entitiesToBeSaved;
    }

    @Override
    public <T> void deleteById(Object id, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        String nameOfParameter = "id";
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter));
        log.debug(() -> String.format("Deleting entity with id %s ", id));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        ResultSummary summary = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statement)).in(this.getDatabaseName()).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id)).to(nameOfParameter)).run();
        log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
    }

    @Override
    public <T> void deleteByIdWithVersion(Object id, Class<T> domainType, Neo4jPersistentProperty versionProperty, Object versionValue) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        String nameOfParameter = "id";
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter)).and(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String[])new String[]{versionProperty.getPropertyName()}).isEqualTo((Expression)Cypher.parameter((String)"__version__")).or(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String[])new String[]{versionProperty.getPropertyName()}).isNull()));
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, condition).returning(new Expression[]{Constants.NAME_OF_ROOT_NODE}).build();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(nameOfParameter, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id));
        parameters.put("__version__", versionValue);
        this.createExecutableQuery(domainType, statement, parameters).getSingleResult().orElseThrow(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
        this.deleteById(id, domainType);
    }

    @Override
    public <T> void deleteAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        String nameOfParameter = "ids";
        Condition condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)nameOfParameter));
        log.debug(() -> String.format("Deleting all entities with the following ids: %s ", ids));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        ResultSummary summary = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statement)).in(this.getDatabaseName()).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids)).to(nameOfParameter)).run();
        log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
    }

    @Override
    public void deleteAll(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        log.debug(() -> String.format("Deleting all nodes with primary label %s", entityMetaData.getPrimaryLabel()));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData);
        ResultSummary summary = this.neo4jClient.query(renderer.render(statement)).in(this.getDatabaseName()).run();
        log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, String cypherStatement) {
        return this.createExecutableQuery(domainType, cypherStatement, Collections.emptyMap());
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, Statement statement, Map<String, Object> parameters) {
        return this.createExecutableQuery(domainType, renderer.render(statement), parameters);
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, String cypherStatement, Map<String, Object> parameters) {
        Assert.notNull((Object)this.neo4jMappingContext.getPersistentEntity(domainType), (String)"Cannot get or create persistent entity.");
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withCypherQuery(cypherStatement).withParameters(parameters).usingMappingFunction(this.neo4jMappingContext.getRequiredMappingFunctionFor(domainType)).build();
        return this.toExecutableQuery(preparedQuery);
    }

    private <T> T processRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, Object parentObject, boolean isParentObjectNew, @Nullable String inDatabase, Object parentEntity) {
        return this.processNestedRelations(neo4jPersistentEntity, parentObject, isParentObjectNew, inDatabase, new NestedRelationshipProcessingStateMachine(parentEntity));
    }

    private <T> T processNestedRelations(Neo4jPersistentEntity<?> sourceEntity, Object parentObject, boolean isParentObjectNew, @Nullable String inDatabase, NestedRelationshipProcessingStateMachine stateMachine) {
        PersistentPropertyAccessor propertyAccessor = sourceEntity.getPropertyAccessor(parentObject);
        Object fromId = propertyAccessor.getProperty(sourceEntity.getRequiredIdProperty());
        sourceEntity.doWithAssociations(association -> {
            Neo4jPersistentProperty idProperty;
            NestedRelationshipContext relationshipContext = NestedRelationshipContext.of((Association<Neo4jPersistentProperty>)association, propertyAccessor, sourceEntity);
            Collection<?> relatedValuesToStore = MappingSupport.unifyRelationshipValue(relationshipContext.getInverse(), relationshipContext.getValue());
            RelationshipDescription relationshipDescription = relationshipContext.getRelationship();
            RelationshipDescription relationshipDescriptionObverse = relationshipDescription.getRelationshipObverse();
            if (!relationshipDescription.hasInternalIdProperty()) {
                idProperty = null;
            } else {
                Neo4jPersistentEntity relationshipPropertiesEntity = (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity();
                idProperty = (Neo4jPersistentProperty)relationshipPropertiesEntity.getIdProperty();
            }
            NestedRelationshipProcessingStateMachine.ProcessState processState = stateMachine.getStateOf(fromId, relationshipDescriptionObverse, relatedValuesToStore);
            if (processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_RELATIONSHIPS || processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_BOTH) {
                return;
            }
            if (!isParentObjectNew && !stateMachine.hasProcessedRelationship(fromId, relationshipDescription)) {
                ArrayList<Long> knownRelationshipsIds = new ArrayList<Long>();
                if (idProperty != null) {
                    for (Object relatedValueToStore : relatedValuesToStore) {
                        Long id;
                        if (relatedValueToStore == null || (id = (Long)relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).getProperty((PersistentProperty)idProperty)) == null) continue;
                        knownRelationshipsIds.add(id);
                    }
                }
                Statement relationshipRemoveQuery = this.cypherGenerator.prepareDeleteOf(sourceEntity, relationshipDescription);
                ((Neo4jClient.RunnableSpecTightToDatabase)((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(relationshipRemoveQuery)).in(inDatabase).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getIdProperty(), fromId)).to("fromId")).bind(knownRelationshipsIds).to("__knownRelationShipIds__")).run();
            }
            if (relationshipContext.inverseValueIsEmpty()) {
                return;
            }
            stateMachine.markRelationshipAsProcessed(fromId, relationshipDescription);
            for (Object relatedValueToStore : relatedValuesToStore) {
                Object relatedNode = relationshipContext.identifyAndExtractRelationshipTargetNode(relatedValueToStore);
                Neo4jPersistentEntity targetEntity = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(relatedNode.getClass());
                boolean isEntityNew = targetEntity.isNew(relatedNode);
                relatedNode = this.eventSupport.maybeCallBeforeBind(relatedNode);
                Long relatedInternalId = stateMachine.hasProcessedValue(relatedValueToStore) ? this.queryRelatedNode(relatedNode, targetEntity, inDatabase) : this.saveRelatedNode(relatedNode, relationshipContext.getAssociationTargetType(), targetEntity, inDatabase);
                stateMachine.markValueAsProcessed(relatedValueToStore);
                Object idValue = idProperty != null ? relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).getProperty((PersistentProperty)idProperty) : null;
                boolean isNewRelationship = idValue == null;
                CreateRelationshipStatementHolder statementHolder = this.neo4jMappingContext.createStatement(sourceEntity, relationshipContext, relatedValueToStore, isNewRelationship);
                Optional relationshipInternalId = ((Neo4jClient.RunnableSpecTightToDatabase)((Neo4jClient.RunnableSpecTightToDatabase)((Neo4jClient.RunnableSpecTightToDatabase)((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statementHolder.getStatement())).in(inDatabase).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getRequiredIdProperty(), fromId)).to("fromId")).bind(relatedInternalId).to("toId")).bind(idValue).to("__knownRelationShipId__")).bindAll(statementHolder.getProperties())).fetchAs(Long.class).one();
                if (idProperty != null && isNewRelationship) {
                    relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).setProperty((PersistentProperty)idProperty, relationshipInternalId.get());
                }
                PersistentPropertyAccessor targetPropertyAccessor = targetEntity.getPropertyAccessor(relatedNode);
                if (targetEntity.isUsingInternalIds()) {
                    targetPropertyAccessor.setProperty(targetEntity.getRequiredIdProperty(), (Object)relatedInternalId);
                }
                if (processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_VALUES) continue;
                this.processNestedRelations(targetEntity, targetPropertyAccessor.getBean(), isEntityNew, inDatabase, stateMachine);
            }
        });
        return (T)propertyAccessor.getBean();
    }

    private <Y> Long queryRelatedNode(Object entity, Neo4jPersistentEntity<?> targetNodeDescription, @Nullable String inDatabase) {
        Neo4jPersistentProperty requiredIdProperty = (Neo4jPersistentProperty)targetNodeDescription.getRequiredIdProperty();
        PersistentPropertyAccessor targetPropertyAccessor = targetNodeDescription.getPropertyAccessor(entity);
        Object idValue = targetPropertyAccessor.getProperty((PersistentProperty)requiredIdProperty);
        return (Long)((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareMatchOf(targetNodeDescription, targetNodeDescription.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"))).returning(new String[]{"__internalNeo4jId__"}).build())).in(inDatabase).bindAll(Collections.singletonMap("__id__", idValue))).fetchAs(Long.class).one().get();
    }

    private <Y> Long saveRelatedNode(Object entity, Class<Y> entityType, NodeDescription targetNodeDescription, @Nullable String inDatabase) {
        DynamicLabels dynamicLabels = this.determineDynamicLabels(entity, (Neo4jPersistentEntity)targetNodeDescription, inDatabase);
        Optional optionalSavedNodeId = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOf(targetNodeDescription, dynamicLabels))).in(inDatabase).bind(entity).with(this.neo4jMappingContext.getRequiredBinderFunctionFor(entityType))).fetchAs(Long.class).one();
        if (((Neo4jPersistentEntity)targetNodeDescription).hasVersionProperty() && !optionalSavedNodeId.isPresent()) {
            throw new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE);
        }
        return (Long)optionalSavedNodeId.get();
    }

    private String getDatabaseName() {
        return this.databaseSelectionProvider.getDatabaseSelection().getValue();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.eventSupport = EventSupport.discoverCallbacks(this.neo4jMappingContext, beanFactory);
    }

    @Override
    public <T> Neo4jOperations.ExecutableQuery<T> toExecutableQuery(Class<T> domainType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        return this.createExecutableQuery(domainType, queryFragmentsAndParameters);
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withQueryFragmentsAndParameters(queryFragmentsAndParameters).usingMappingFunction(this.neo4jMappingContext.getRequiredMappingFunctionFor(domainType)).build();
        return this.toExecutableQuery(preparedQuery);
    }

    @Override
    public <T> Neo4jOperations.ExecutableQuery<T> toExecutableQuery(PreparedQuery<T> preparedQuery) {
        return new DefaultExecutableQuery<T>(preparedQuery);
    }

    final class DefaultExecutableQuery<T>
    implements Neo4jOperations.ExecutableQuery<T> {
        private final PreparedQuery<T> preparedQuery;

        DefaultExecutableQuery(PreparedQuery<T> preparedQuery) {
            this.preparedQuery = preparedQuery;
        }

        @Override
        public List<T> getResults() {
            Collection all = this.createFetchSpec().map(Neo4jClient.RecordFetchSpec::all).orElse(Collections.emptyList());
            if (this.preparedQuery.resultsHaveBeenAggregated()) {
                return all.stream().flatMap(nested -> ((Collection)nested).stream()).distinct().collect(Collectors.toList());
            }
            return all.stream().collect(Collectors.toList());
        }

        @Override
        public Optional<T> getSingleResult() {
            try {
                Optional<Object> one = this.createFetchSpec().flatMap(Neo4jClient.RecordFetchSpec::one);
                if (this.preparedQuery.resultsHaveBeenAggregated()) {
                    return one.map(aggregatedResults -> ((LinkedHashSet)aggregatedResults).iterator().next());
                }
                return one;
            }
            catch (NoSuchRecordException e) {
                throw new IncorrectResultSizeDataAccessException(e.getMessage(), 1);
            }
        }

        @Override
        public T getRequiredSingleResult() {
            Optional<Object> one = this.createFetchSpec().flatMap(Neo4jClient.RecordFetchSpec::one);
            if (this.preparedQuery.resultsHaveBeenAggregated()) {
                one = one.map(aggregatedResults -> ((LinkedHashSet)aggregatedResults).iterator().next());
            }
            return (T)one.orElseThrow(() -> new NoResultException(1, this.preparedQuery.getQueryFragmentsAndParameters().getCypherQuery()));
        }

        /*
         * Unable to fully structure code
         */
        private Optional<Neo4jClient.RecordFetchSpec<T>> createFetchSpec() {
            queryFragmentsAndParameters = this.preparedQuery.getQueryFragmentsAndParameters();
            cypherQuery = queryFragmentsAndParameters.getCypherQuery();
            finalParameters = this.preparedQuery.getQueryFragmentsAndParameters().getParameters();
            queryFragments = queryFragmentsAndParameters.getQueryFragments();
            entityMetaData = (Neo4jPersistentEntity)queryFragmentsAndParameters.getNodeDescription();
            if (entityMetaData == null) ** GOTO lbl-1000
            if (entityMetaData.containsPossibleCircles((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, includeField(java.lang.String ), (Ljava/lang/String;)Z)((QueryFragmentsAndParameters.QueryFragments)queryFragments))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = containsPossibleCircles = false;
            }
            if (cypherQuery == null || containsPossibleCircles) {
                parameters = queryFragmentsAndParameters.getParameters();
                if (containsPossibleCircles && !queryFragments.isScalarValueReturn()) {
                    genericQueryAndParameters = this.createQueryAndParameters(entityMetaData, queryFragments, parameters);
                    if (genericQueryAndParameters.isEmpty()) {
                        return Optional.empty();
                    }
                    cypherQuery = Neo4jTemplate.access$000().render(queryFragments.generateGenericStatement());
                    finalParameters = genericQueryAndParameters.getParameters();
                } else {
                    cypherQuery = Neo4jTemplate.access$000().render(queryFragments.toStatement());
                }
            }
            newMappingSpec = ((Neo4jClient.RunnableSpecTightToDatabase)Neo4jTemplate.access$200(Neo4jTemplate.this).query(cypherQuery).in(Neo4jTemplate.access$100(Neo4jTemplate.this)).bindAll(finalParameters)).fetchAs(this.preparedQuery.getResultType());
            return Optional.of(this.preparedQuery.getOptionalMappingFunction().map((Function<BiFunction, Neo4jClient.RecordFetchSpec>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$createFetchSpec$4(org.springframework.data.neo4j.core.Neo4jClient$MappingSpec java.util.function.BiFunction ), (Ljava/util/function/BiFunction;)Lorg/springframework/data/neo4j/core/Neo4jClient$RecordFetchSpec;)(newMappingSpec)).orElse(newMappingSpec));
        }

        private GenericQueryAndParameters createQueryAndParameters(Neo4jPersistentEntity<?> entityMetaData, QueryFragmentsAndParameters.QueryFragments queryFragments, Map<String, Object> parameters) {
            Statement rootNodesStatement = Neo4jTemplate.this.cypherGenerator.prepareMatchOf(entityMetaData, queryFragments.getMatchOn(), queryFragments.getCondition()).returning(new String[]{"__sn__"}).build();
            HashSet<Long> rootNodeIds = new HashSet<Long>((Collection)((Neo4jClient.RunnableSpecTightToDatabase)Neo4jTemplate.this.neo4jClient.query(renderer.render(rootNodesStatement)).in(Neo4jTemplate.this.getDatabaseName()).bindAll(parameters)).fetch().one().map(values -> values.get("__sn__")).get());
            if (rootNodeIds.isEmpty()) {
                return GenericQueryAndParameters.EMPTY;
            }
            HashSet<Long> relationshipIds = new HashSet<Long>();
            HashSet<Long> relatedNodeIds = new HashSet<Long>();
            for (RelationshipDescription relationshipDescription : entityMetaData.getRelationshipsInHierarchy(fieldName -> queryFragments.includeField((String)fieldName))) {
                Statement statement = Neo4jTemplate.this.cypherGenerator.prepareMatchOf(entityMetaData, relationshipDescription, queryFragments.getMatchOn(), queryFragments.getCondition()).returning(Neo4jTemplate.this.cypherGenerator.createReturnStatementForMatch(entityMetaData)).build();
                ((Neo4jClient.RunnableSpecTightToDatabase)Neo4jTemplate.this.neo4jClient.query(renderer.render(statement)).in(Neo4jTemplate.this.getDatabaseName()).bindAll(parameters)).fetch().one().ifPresent(this.iterateAndMapNextLevel(relationshipIds, relatedNodeIds, relationshipDescription));
            }
            return new GenericQueryAndParameters(rootNodeIds, relationshipIds, relatedNodeIds);
        }

        private void iterateNextLevel(Collection<Long> nodeIds, Neo4jPersistentEntity<?> target, Set<Long> relationshipIds, Set<Long> relatedNodeIds) {
            Collection relationships = target.getRelationshipsInHierarchy(s -> true);
            for (RelationshipDescription relationshipDescription : relationships) {
                Node node = Cypher.anyNode((SymbolicName)Constants.NAME_OF_ROOT_NODE);
                Statement statement = Neo4jTemplate.this.cypherGenerator.prepareMatchOf(target, relationshipDescription, null, Functions.id((Node)node).in((Expression)Cypher.parameter((String)"__ids__"))).returning(Neo4jTemplate.this.cypherGenerator.createGenericReturnStatement()).build();
                ((Neo4jClient.RunnableSpecTightToDatabase)Neo4jTemplate.this.neo4jClient.query(renderer.render(statement)).in(Neo4jTemplate.this.getDatabaseName()).bindAll(Collections.singletonMap("__ids__", nodeIds))).fetch().one().ifPresent(this.iterateAndMapNextLevel(relationshipIds, relatedNodeIds, relationshipDescription));
            }
        }

        @NonNull
        private Consumer<Map<String, Object>> iterateAndMapNextLevel(Set<Long> relationshipIds, Set<Long> relatedNodeIds, RelationshipDescription relationshipDescription) {
            return record -> {
                List newRelationshipIds = (List)record.get("__sr__");
                relationshipIds.addAll(newRelationshipIds);
                List newRelatedNodeIds = (List)record.get("__srn__");
                HashSet<Long> relatedIds = new HashSet<Long>(newRelatedNodeIds);
                relatedIds.removeAll(relatedNodeIds);
                relatedNodeIds.addAll(relatedIds);
                if (!relatedIds.isEmpty()) {
                    this.iterateNextLevel(relatedIds, (Neo4jPersistentEntity)relationshipDescription.getTarget(), relationshipIds, relatedNodeIds);
                }
            };
        }

        private static /* synthetic */ Neo4jClient.RecordFetchSpec lambda$createFetchSpec$4(Neo4jClient.MappingSpec newMappingSpec, BiFunction f) {
            return newMappingSpec.mappedBy(f);
        }
    }
}

