/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class MappingAwarePageableArgumentResolver
implements HandlerMethodArgumentResolver {
    private final JacksonMappingAwareSortTranslator translator;
    private final PageableHandlerMethodArgumentResolver delegate;

    public MappingAwarePageableArgumentResolver(JacksonMappingAwareSortTranslator translator, PageableHandlerMethodArgumentResolver delegate) {
        Assert.notNull((Object)translator, (String)"JacksonMappingSortTranslator must not be null!");
        Assert.notNull((Object)delegate, (String)"PageableHandlerMethodArgumentResolver must not be null!");
        this.translator = translator;
        this.delegate = delegate;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return this.delegate.supportsParameter(parameter);
    }

    public Pageable resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Pageable pageable = this.delegate.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (pageable == null || pageable.getSort() == null) {
            return null;
        }
        Sort translated = this.translator.translateSort(pageable.getSort(), parameter, webRequest);
        return new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), translated);
    }
}

