/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.outbound;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.social.twitter.api.SearchParameters;
import org.springframework.social.twitter.api.SearchResults;
import org.springframework.social.twitter.api.Twitter;
import org.springframework.util.Assert;

public class TwitterSearchOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private static final int DEFAULT_PAGE_SIZE = 20;
    private final Twitter twitter;
    private volatile Expression searchArgsExpression;
    private volatile EvaluationContext evaluationContext;

    public TwitterSearchOutboundGateway(Twitter twitter) {
        Assert.notNull((Object)twitter, (String)"'twitter' must not be null");
        this.twitter = twitter;
    }

    public void setSearchArgsExpression(Expression searchArgsExpression) {
        Assert.notNull((Object)searchArgsExpression, (String)"'searchArgsExpression' must not be null");
        this.searchArgsExpression = searchArgsExpression;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public String getComponentType() {
        return "twitter:search-outbound-gateway";
    }

    protected Twitter getTwitter() {
        return this.twitter;
    }

    protected void doInit() {
        super.doInit();
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
            TypeLocator typeLocator = this.evaluationContext.getTypeLocator();
            if (typeLocator instanceof StandardTypeLocator) {
                ((StandardTypeLocator)typeLocator).registerImport("org.springframework.social.twitter.api");
            }
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        SearchParameters searchParameters;
        Object args = this.searchArgsExpression != null ? this.searchArgsExpression.getValue(this.evaluationContext, requestMessage) : requestMessage.getPayload();
        Assert.notNull((Object)args, (String)"The twitter search expression cannot evaluate to 'null'.");
        if (args instanceof SearchParameters) {
            searchParameters = (SearchParameters)args;
        } else if (args instanceof String) {
            searchParameters = new SearchParameters((String)args).count(20);
        } else if (args instanceof List) {
            List list = (List)args;
            Assert.isTrue((list.size() > 0 && list.size() < 5 ? 1 : 0) != 0, (String)"Between 1 and 4 search arguments are required");
            Assert.isInstanceOf(String.class, list.get(0), (String)"The first search argument (query) must be a String");
            searchParameters = new SearchParameters((String)list.get(0));
            if (list.size() > 1) {
                Assert.isInstanceOf(Number.class, list.get(1), (String)"The second search argument (pageSize) must be a Number");
                searchParameters.count(((Number)list.get(1)).intValue());
                if (list.size() > 2) {
                    Assert.isInstanceOf(Number.class, list.get(2), (String)"The third search argument (sinceId) must be a Number");
                    searchParameters.sinceId(((Number)list.get(2)).longValue());
                }
                if (list.size() > 3) {
                    Assert.isInstanceOf(Number.class, list.get(3), (String)"The fourth search argument (maxId) must be a Number");
                    searchParameters.maxId(((Number)list.get(3)).longValue());
                }
            }
        } else {
            throw new IllegalArgumentException("Search Expression must evaluate to a 'SearchParameters', 'String' or 'List'.");
        }
        SearchResults results = this.getTwitter().searchOperations().search(searchParameters);
        if (results != null) {
            List tweets = results.getTweets() != null ? results.getTweets() : Collections.emptyList();
            return this.getMessageBuilderFactory().withPayload((Object)tweets).setHeader("twitter_searchMetadata", (Object)results.getSearchMetadata());
        }
        return null;
    }
}

