/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.core.ClientIdSuffixAware;
import org.springframework.kafka.core.ConsumerFactory;

public class DefaultKafkaConsumerFactory<K, V>
implements ConsumerFactory<K, V>,
ClientIdSuffixAware<K, V> {
    private final Map<String, Object> configs;
    private Deserializer<K> keyDeserializer;
    private Deserializer<V> valueDeserializer;

    public DefaultKafkaConsumerFactory(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this.configs = new HashMap<String, Object>(configs);
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
    }

    public void setKeyDeserializer(Deserializer<K> keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
    }

    public void setValueDeserializer(Deserializer<V> valueDeserializer) {
        this.valueDeserializer = valueDeserializer;
    }

    public Map<String, Object> getConfigurationProperties() {
        return Collections.unmodifiableMap(this.configs);
    }

    @Override
    public Consumer<K, V> createConsumer() {
        return this.createKafkaConsumer();
    }

    @Override
    public Consumer<K, V> createConsumer(String clientIdSuffix) {
        return this.createKafkaConsumer(clientIdSuffix);
    }

    protected KafkaConsumer<K, V> createKafkaConsumer() {
        return this.createKafkaConsumer(this.configs);
    }

    protected KafkaConsumer<K, V> createKafkaConsumer(String clientIdSuffix) {
        if (!this.configs.containsKey("client.id") || clientIdSuffix == null) {
            return this.createKafkaConsumer();
        }
        HashMap<String, Object> modifiedClientIdConfigs = new HashMap<String, Object>(this.configs);
        modifiedClientIdConfigs.put("client.id", modifiedClientIdConfigs.get("client.id") + clientIdSuffix);
        return this.createKafkaConsumer(modifiedClientIdConfigs);
    }

    protected KafkaConsumer<K, V> createKafkaConsumer(Map<String, Object> configs) {
        return new KafkaConsumer(configs, this.keyDeserializer, this.valueDeserializer);
    }

    @Override
    public boolean isAutoCommit() {
        Object auto = this.configs.get("enable.auto.commit");
        return auto instanceof Boolean ? (Boolean)auto : (auto instanceof String ? Boolean.valueOf((String)auto) : true);
    }
}

